/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedShutdownStrategyTest
extends ManagementTestSupport {
    public void testManagedShutdownStrategy() throws Exception {
        if (ManagedShutdownStrategyTest.isPlatform("aix")) {
            return;
        }
        this.context.getShutdownStrategy().setTimeout(300L);
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        Long timeout = (Long)mbeanServer.getAttribute(on, "Timeout");
        ManagedShutdownStrategyTest.assertEquals((long)300L, (long)timeout);
        TimeUnit unit = (TimeUnit)((Object)mbeanServer.getAttribute(on, "TimeUnit"));
        ManagedShutdownStrategyTest.assertEquals((String)"seconds", (String)unit.toString().toLowerCase(Locale.ENGLISH));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo").to("mock:foo");
            }
        };
    }
}

