/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.CamelContext;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedSendDynamicProcessorTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().getManagementAgent().setStatisticsLevel(ManagementStatisticsLevel.Extended);
        return context;
    }

    public void testManageSendDynamicProcessor() throws Exception {
        if (ManagedSendDynamicProcessorTest.isPlatform("aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(2);
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "whereto", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "whereto", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hi World", "whereto", (Object)"bar");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedSendDynamicProcessorTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedSendDynamicProcessorTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedSendDynamicProcessorTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        String uri = (String)mbeanServer.getAttribute(on, "Uri");
        ManagedSendDynamicProcessorTest.assertEquals((String)"direct:${header.whereto}", (String)uri);
        String pattern = (String)mbeanServer.getAttribute(on, "MessageExchangePattern");
        ManagedSendDynamicProcessorTest.assertNull((Object)pattern);
        TabularData data = (TabularData)mbeanServer.invoke(on, "extendedInformation", null, null);
        ManagedSendDynamicProcessorTest.assertNotNull((Object)data);
        ManagedSendDynamicProcessorTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedSendDynamicProcessorTest.assertNotNull((Object)data);
        ManagedSendDynamicProcessorTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedSendDynamicProcessorTest.assertNotNull((Object)data);
        ManagedSendDynamicProcessorTest.assertEquals((int)6, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedSendDynamicProcessorTest.assertNotNull((Object)json);
        ManagedSendDynamicProcessorTest.assertTrue((boolean)json.contains("\"description\": \"Sends the message to a dynamic endpoint"));
        ManagedSendDynamicProcessorTest.assertTrue((boolean)json.contains(" \"uri\": { \"kind\": \"attribute\", \"required\": \"true\", \"type\": \"string\", \"javaType\": \"java.lang.String\", \"deprecated\": \"false\", \"value\": \"direct:${header.whereto}\""));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").toD("direct:${header.whereto}")).id("mysend");
                this.from("direct:foo").to("mock:foo");
                this.from("direct:bar").to("mock:bar");
            }
        };
    }
}

