/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedSedaEndpointTest
extends ManagementTestSupport {
    public void testSedaEndpoint() throws Exception {
        if (ManagedSedaEndpointTest.isPlatform("aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.template.sendBody("seda:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"seda://start\"");
        String uri = (String)mbeanServer.getAttribute(name, "EndpointUri");
        ManagedSedaEndpointTest.assertEquals((String)"seda://start", (String)uri);
        Long timeout = (Long)mbeanServer.getAttribute(name, "Timeout");
        ManagedSedaEndpointTest.assertEquals((int)30000, (int)timeout.intValue());
        Integer size = (Integer)mbeanServer.getAttribute(name, "CurrentQueueSize");
        ManagedSedaEndpointTest.assertEquals((int)0, (int)size);
        Boolean singleton = (Boolean)mbeanServer.getAttribute(name, "Singleton");
        ManagedSedaEndpointTest.assertEquals((boolean)true, (boolean)singleton);
        this.context.stopRoute("foo");
        this.template.sendBody("seda:start", (Object)"Hi World");
        size = (Integer)mbeanServer.getAttribute(name, "CurrentQueueSize");
        ManagedSedaEndpointTest.assertEquals((int)1, (int)size);
        Long size2 = (Long)mbeanServer.invoke(name, "queueSize", null, null);
        ManagedSedaEndpointTest.assertEquals((long)1L, (long)size2);
        String out = (String)mbeanServer.invoke(name, "browseExchange", new Object[]{0}, new String[]{"java.lang.Integer"});
        ManagedSedaEndpointTest.assertNotNull((Object)out);
        ManagedSedaEndpointTest.assertTrue((boolean)out.contains("Hi World"));
        mbeanServer.invoke(name, "purgeQueue", null, null);
        size = (Integer)mbeanServer.getAttribute(name, "CurrentQueueSize");
        ManagedSedaEndpointTest.assertEquals((int)0, (int)size);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:start").routeId("foo").to("log:foo")).to("mock:result");
            }
        };
    }
}

