/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedRouteStopWithAbortAfterTimeoutTest
extends ManagementTestSupport {
    public void testStopRouteWithAbortAfterTimeoutTrue() throws Exception {
        if (ManagedRouteStopWithAbortAfterTimeoutTest.isPlatform("aix") || ManagedRouteStopWithAbortAfterTimeoutTest.isPlatform("windows")) {
            return;
        }
        MockEndpoint mockEP = this.getMockEndpoint("mock:result");
        mockEP.setExpectedMessageCount(10);
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteStopWithAbortAfterTimeoutTest.getRouteObjectName(mbeanServer);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopWithAbortAfterTimeoutTest.assertEquals((String)"route should be started", (String)ServiceStatus.Started.name(), (String)state);
        for (int i = 0; i < 5; ++i) {
            this.template.sendBody("seda:start", (Object)("message-" + i));
        }
        Long timeout = new Long(2L);
        Boolean abortAfterTimeout = Boolean.TRUE;
        Object[] params = new Object[]{timeout, abortAfterTimeout};
        String[] sig = new String[]{"java.lang.Long", "java.lang.Boolean"};
        Boolean stopRouteResponse = (Boolean)mbeanServer.invoke(on, "stop", params, sig);
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopWithAbortAfterTimeoutTest.assertFalse((String)"stopRoute response should be False", (boolean)stopRouteResponse);
        ManagedRouteStopWithAbortAfterTimeoutTest.assertEquals((String)"route should still be started", (String)ServiceStatus.Started.name(), (String)state);
        for (int i = 5; i < 10; ++i) {
            this.template.sendBody("seda:start", (Object)("message-" + i));
        }
        mockEP.assertIsSatisfied();
    }

    public void testStopRouteWithAbortAfterTimeoutFalse() throws Exception {
        if (ManagedRouteStopWithAbortAfterTimeoutTest.isPlatform("aix") || ManagedRouteStopWithAbortAfterTimeoutTest.isPlatform("windows")) {
            return;
        }
        MockEndpoint mockEP = this.getMockEndpoint("mock:result");
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteStopWithAbortAfterTimeoutTest.getRouteObjectName(mbeanServer);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopWithAbortAfterTimeoutTest.assertEquals((String)"route should be started", (String)ServiceStatus.Started.name(), (String)state);
        for (int i = 0; i < 5; ++i) {
            this.template.sendBody("seda:start", (Object)("message-" + i));
        }
        Long timeout = new Long(2L);
        Boolean abortAfterTimeout = Boolean.FALSE;
        Object[] params = new Object[]{timeout, abortAfterTimeout};
        String[] sig = new String[]{"java.lang.Long", "java.lang.Boolean"};
        Boolean stopRouteResponse = (Boolean)mbeanServer.invoke(on, "stop", params, sig);
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopWithAbortAfterTimeoutTest.assertTrue((String)"stopRoute response should be True", (boolean)stopRouteResponse);
        ManagedRouteStopWithAbortAfterTimeoutTest.assertEquals((String)"route should be stopped", (String)ServiceStatus.Stopped.name(), (String)state);
        for (int i = 5; i < 10; ++i) {
            this.template.sendBody("seda:start", (Object)("message-" + i));
        }
        Thread.sleep(3000L);
        ManagedRouteStopWithAbortAfterTimeoutTest.assertTrue((String)"Should not have received more than 5 messages", (mockEP.getExchanges().size() <= 5 ? 1 : 0) != 0);
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteStopWithAbortAfterTimeoutTest.assertEquals((int)1, (int)set.size());
        return set.iterator().next();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ManagedRouteStopWithAbortAfterTimeoutTest.this.context.getShutdownStrategy().setTimeout(3L);
                this.from("seda:start").delay(500L).to("mock:result");
            }
        };
    }
}

