/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.management.MyManagedBean;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ManagementAgent;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedResourceTest
extends ManagementTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedResourceTest.class);

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").bean(MyManagedBean.class)).id("myManagedBean")).log("${body}")).to("seda:foo")).to("mock:result");
            }
        };
    }

    @Test
    public void testManagedResource() throws Exception {
        if (ManagedResourceTest.isPlatform("aix")) {
            return;
        }
        ManagementAgent managementAgent = this.context.getManagementStrategy().getManagementAgent();
        TestCase.assertNotNull((Object)managementAgent);
        MBeanServer mBeanServer = managementAgent.getMBeanServer();
        TestCase.assertNotNull((Object)mBeanServer);
        String mBeanServerDefaultDomain = managementAgent.getMBeanServerDefaultDomain();
        TestCase.assertEquals((String)"org.apache.camel", (String)mBeanServerDefaultDomain);
        String managementName = this.context.getManagementName();
        TestCase.assertNotNull((String)"CamelContext should have a management name if JMX is enabled", (Object)managementName);
        LOG.info("managementName = {}", (Object)managementName);
        ObjectName onContext = ObjectName.getInstance(mBeanServerDefaultDomain + ":context=" + managementName + ",type=context,name=\"" + this.context.getName() + "\"");
        TestCase.assertTrue((String)"Should be registered", (boolean)mBeanServer.isRegistered(onContext));
        ObjectName onManagedBean = ObjectName.getInstance(mBeanServerDefaultDomain + ":context=" + managementName + ",type=processors,name=\"myManagedBean\"");
        LOG.info("Canonical Name = {}", (Object)onManagedBean.getCanonicalName());
        TestCase.assertTrue((String)"Should be registered", (boolean)mBeanServer.isRegistered(onManagedBean));
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.template.sendBody("direct:start", (Object)"Camel Rocks!");
        int camelsSeenCount = (Integer)mBeanServer.getAttribute(onManagedBean, "CamelsSeenCount");
        TestCase.assertEquals((int)2, (int)camelsSeenCount);
        mBeanServer.invoke(onManagedBean, "resetCamelsSeenCount", null, null);
        camelsSeenCount = (Integer)mBeanServer.getAttribute(onManagedBean, "CamelsSeenCount");
        TestCase.assertEquals((int)0, (int)camelsSeenCount);
        String camelId = (String)mBeanServer.getAttribute(onManagedBean, "CamelId");
        ManagedResourceTest.assertEquals((String)this.context.getName(), (String)camelId);
        String state = (String)mBeanServer.getAttribute(onManagedBean, "State");
        ManagedResourceTest.assertEquals((String)"Started", (String)state);
        String fqn = (String)mBeanServer.getAttribute(onManagedBean, "BeanClassName");
        ManagedResourceTest.assertEquals((String)MyManagedBean.class.getCanonicalName(), (String)fqn);
    }
}

