/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.Expression;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ExpressionNode;

public class ManagedLoopTest
extends ManagementTestSupport {
    public void testManageLoop() throws Exception {
        if (ManagedLoopTest.isPlatform("aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(2);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"2");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedLoopTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedLoopTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedLoopTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        String lan = (String)mbeanServer.getAttribute(on, "ExpressionLanguage");
        ManagedLoopTest.assertEquals((String)"header", (String)lan);
        String uri = (String)mbeanServer.getAttribute(on, "Expression");
        ManagedLoopTest.assertEquals((String)"foo", (String)uri);
        TabularData data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedLoopTest.assertNotNull((Object)data);
        ManagedLoopTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedLoopTest.assertNotNull((Object)data);
        ManagedLoopTest.assertEquals((int)5, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedLoopTest.assertNotNull((Object)json);
        ManagedLoopTest.assertTrue((boolean)json.contains("\"description\": \"Processes a message multiple times"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)this.from("direct:start").loop((Expression)this.header("foo")).id("mysend")).to("mock:foo");
            }
        };
    }
}

