/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedInflightStatisticsTest
extends ManagementTestSupport {
    public void testManageStatistics() throws Exception {
        if (ManagedInflightStatisticsTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedInflightStatisticsTest.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        Long inflight = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
        ManagedInflightStatisticsTest.assertEquals((long)0L, (long)inflight);
        Long ts = (Long)mbeanServer.getAttribute(on, "OldestInflightDuration");
        ManagedInflightStatisticsTest.assertNull((Object)ts);
        String id = (String)mbeanServer.getAttribute(on, "OldestInflightExchangeId");
        ManagedInflightStatisticsTest.assertNull((Object)id);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(2);
        this.template.asyncSendBody("direct:start", (Object)1000L);
        Thread.sleep(500L);
        this.template.asyncSendBody("direct:start", (Object)1000L);
        Thread.sleep(100L);
        inflight = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
        ManagedInflightStatisticsTest.assertEquals((long)2L, (long)inflight);
        ts = (Long)mbeanServer.getAttribute(on, "OldestInflightDuration");
        ManagedInflightStatisticsTest.assertNotNull((Object)ts);
        id = (String)mbeanServer.getAttribute(on, "OldestInflightExchangeId");
        ManagedInflightStatisticsTest.assertNotNull((Object)id);
        Thread.sleep(500L);
        Long ts2 = (Long)mbeanServer.getAttribute(on, "OldestInflightDuration");
        ManagedInflightStatisticsTest.assertNotNull((Object)ts2);
        String id2 = (String)mbeanServer.getAttribute(on, "OldestInflightExchangeId");
        ManagedInflightStatisticsTest.assertNotNull((Object)id2);
        ManagedInflightStatisticsTest.assertTrue((!id2.equals(id) ? 1 : 0) != 0);
        Thread.sleep(500L);
        this.assertMockEndpointsSatisfied();
        inflight = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
        ManagedInflightStatisticsTest.assertEquals((long)0L, (long)inflight);
        ts = (Long)mbeanServer.getAttribute(on, "OldestInflightDuration");
        ManagedInflightStatisticsTest.assertNull((Object)ts);
        id = (String)mbeanServer.getAttribute(on, "OldestInflightExchangeId");
        ManagedInflightStatisticsTest.assertNull((Object)id);
    }

    public void testManageStatisticsFailed() throws Exception {
        if (ManagedInflightStatisticsTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedInflightStatisticsTest.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        Long inflight = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
        ManagedInflightStatisticsTest.assertEquals((long)0L, (long)inflight);
        Long ts = (Long)mbeanServer.getAttribute(on, "OldestInflightDuration");
        ManagedInflightStatisticsTest.assertNull((Object)ts);
        String id = (String)mbeanServer.getAttribute(on, "OldestInflightExchangeId");
        ManagedInflightStatisticsTest.assertNull((Object)id);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.template.asyncSendBody("direct:start", (Object)1000L);
        Thread.sleep(500L);
        try {
            this.template.sendBody("direct:start", (Object)"Kaboom");
            ManagedInflightStatisticsTest.fail((String)"Should have thrown exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        inflight = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
        ManagedInflightStatisticsTest.assertEquals((long)1L, (long)inflight);
        ts = (Long)mbeanServer.getAttribute(on, "OldestInflightDuration");
        ManagedInflightStatisticsTest.assertNotNull((Object)ts);
        id = (String)mbeanServer.getAttribute(on, "OldestInflightExchangeId");
        ManagedInflightStatisticsTest.assertNotNull((Object)id);
        this.assertMockEndpointsSatisfied();
        Thread.sleep(500L);
        inflight = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
        ManagedInflightStatisticsTest.assertEquals((long)0L, (long)inflight);
        ts = (Long)mbeanServer.getAttribute(on, "OldestInflightDuration");
        ManagedInflightStatisticsTest.assertNull((Object)ts);
        id = (String)mbeanServer.getAttribute(on, "OldestInflightExchangeId");
        ManagedInflightStatisticsTest.assertNull((Object)id);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if ("Kaboom".equals(body)) {
                            throw new IllegalArgumentException("Forced");
                        }
                        Long delay = (Long)exchange.getIn().getBody();
                        Thread.sleep(delay);
                    }
                })).to("mock:result")).id("mock");
            }
        };
    }
}

