/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Arrays;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.rest.CollectionFormat;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.spi.Registry;

public class ManagedFromRestPlaceholderTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        SimpleRegistry registry = new SimpleRegistry();
        registry.put((Object)"dummy-test", (Object)new DummyRestConsumerFactory());
        DefaultCamelContext answer = new DefaultCamelContext((Registry)registry);
        PropertiesComponent pc = new PropertiesComponent();
        pc.setLocation("classpath:org/apache/camel/management/rest.properties");
        answer.addComponent("properties", (Component)pc);
        return answer;
    }

    public void testFromRestModelPlaceholder() throws Exception {
        if (ManagedFromRestPlaceholderTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        String xml = (String)mbeanServer.invoke(on, "dumpRestsAsXml", new Object[]{true}, new String[]{"boolean"});
        ManagedFromRestPlaceholderTest.assertNotNull((Object)xml);
        this.log.info(xml);
        ManagedFromRestPlaceholderTest.assertTrue((boolean)xml.contains("<rests"));
        ManagedFromRestPlaceholderTest.assertTrue((boolean)xml.contains("<rest path=\"/say/hello\">"));
        ManagedFromRestPlaceholderTest.assertTrue((boolean)xml.contains("<rest path=\"/say/bye\">"));
        ManagedFromRestPlaceholderTest.assertTrue((boolean)xml.contains("</rest>"));
        ManagedFromRestPlaceholderTest.assertTrue((boolean)xml.contains("<get"));
        ManagedFromRestPlaceholderTest.assertTrue((boolean)xml.contains("application/json"));
        ManagedFromRestPlaceholderTest.assertTrue((boolean)xml.contains("<post"));
        ManagedFromRestPlaceholderTest.assertTrue((boolean)xml.contains("application/json"));
        ManagedFromRestPlaceholderTest.assertTrue((boolean)xml.contains("</rests>"));
        ManagedFromRestPlaceholderTest.assertTrue((boolean)xml.contains("<param name=\"header_letter\" type=\"query\" description=\"header param description2\" defaultValue=\"b\" required=\"false\" collectionFormat=\"multi\" dataType=\"string\">"));
        ManagedFromRestPlaceholderTest.assertTrue((boolean)xml.contains("<param name=\"header_count\" type=\"header\" description=\"header param description1\" defaultValue=\"1\" required=\"true\" dataType=\"integer\">"));
        ManagedFromRestPlaceholderTest.assertTrue((boolean)xml.contains("<value>1</value>"));
        ManagedFromRestPlaceholderTest.assertTrue((boolean)xml.contains("<value>a</value>"));
        ManagedFromRestPlaceholderTest.assertTrue((boolean)xml.contains("<responseMessage code=\"300\" message=\"test msg\" responseModel=\"java.lang.Integer\"/>"));
        String xml2 = (String)mbeanServer.invoke(on, "dumpRoutesAsXml", null, null);
        this.log.info(xml2);
        ManagedFromRestPlaceholderTest.assertTrue((boolean)xml2.contains("rest=\"true\""));
        ManagedFromRestPlaceholderTest.assertEquals((int)5, (int)this.context.getRouteDefinitions().size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().host("localhost");
                this.rest("{{foo}}").get().to("direct:hello");
                this.rest("{{bar}}").get().consumes("application/json").param().type(RestParamType.header).description("header param description1").dataType("integer").allowableValues(Arrays.asList("1", "2", "3", "4")).defaultValue("1").name("header_count").required(Boolean.valueOf(true)).endParam().param().type(RestParamType.query).description("header param description2").dataType("string").allowableValues(Arrays.asList("a", "b", "c", "d")).defaultValue("b").collectionFormat(CollectionFormat.multi).name("header_letter").required(Boolean.valueOf(false)).endParam().responseMessage().code(300).message("test msg").responseModel(Integer.class).endResponseMessage().to("direct:bye").post().to("mock:update");
                this.from("direct:hello").transform().constant((Object)"Hello World");
                this.from("direct:bye").transform().constant((Object)"Bye World");
            }
        };
    }
}

