/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedConvertBodyTest
extends ManagementTestSupport {
    public void testManageConvertBody() throws Exception {
        if (ManagedConvertBodyTest.isPlatform("aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedConvertBodyTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedConvertBodyTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedConvertBodyTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        String uri = (String)mbeanServer.getAttribute(on, "Type");
        ManagedConvertBodyTest.assertEquals((String)"byte[]", (String)uri);
        TabularData data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedConvertBodyTest.assertNotNull((Object)data);
        ManagedConvertBodyTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedConvertBodyTest.assertNotNull((Object)data);
        ManagedConvertBodyTest.assertEquals((int)4, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedConvertBodyTest.assertNotNull((Object)json);
        ManagedConvertBodyTest.assertTrue((boolean)json.contains("\"description\": \"Converts the message body to another type"));
        ManagedConvertBodyTest.assertTrue((boolean)json.contains("byte[]"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").convertBodyTo(byte[].class)).id("mysend")).to("mock:foo");
            }
        };
    }
}

