/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.IOException;
import java.sql.SQLException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.LoadBalanceDefinition;

public class ManagedCircuitBreakerLoadBalancerTest
extends ManagementTestSupport {
    public void testManageCircuitBreakerLoadBalancer() throws Exception {
        if (ManagedCircuitBreakerLoadBalancerTest.isPlatform("aix")) {
            return;
        }
        this.getMockEndpoint("mock:foo").whenExchangeReceived(1, new Processor(){

            public void process(Exchange exchange) throws Exception {
                throw new SQLException("Forced");
            }
        });
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
            ManagedCircuitBreakerLoadBalancerTest.fail((String)"Should fail");
        }
        catch (Exception e) {
            ManagedCircuitBreakerLoadBalancerTest.assertIsInstanceOf(SQLException.class, e.getCause());
            ManagedCircuitBreakerLoadBalancerTest.assertEquals((String)"Forced", (String)e.getCause().getMessage());
        }
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedCircuitBreakerLoadBalancerTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedCircuitBreakerLoadBalancerTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedCircuitBreakerLoadBalancerTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        Integer size = (Integer)mbeanServer.getAttribute(on, "Size");
        ManagedCircuitBreakerLoadBalancerTest.assertEquals((int)1, (int)size);
        Long half = (Long)mbeanServer.getAttribute(on, "HalfOpenAfter");
        ManagedCircuitBreakerLoadBalancerTest.assertEquals((long)5000L, (long)half);
        Integer attempts = (Integer)mbeanServer.getAttribute(on, "Threshold");
        ManagedCircuitBreakerLoadBalancerTest.assertEquals((int)2, (int)attempts);
        String exceptions = (String)mbeanServer.getAttribute(on, "Exceptions");
        ManagedCircuitBreakerLoadBalancerTest.assertEquals((String)"java.io.IOException,java.sql.SQLException", (String)exceptions);
        String cbState = (String)mbeanServer.getAttribute(on, "CircuitBreakerState");
        ManagedCircuitBreakerLoadBalancerTest.assertEquals((String)"closed", (String)cbState);
        String dump = (String)mbeanServer.invoke(on, "dumpState", null, null);
        ManagedCircuitBreakerLoadBalancerTest.assertTrue((boolean)dump.startsWith("State closed, failures 0, closed since"));
        TabularData data = (TabularData)mbeanServer.invoke(on, "exceptionStatistics", null, null);
        ManagedCircuitBreakerLoadBalancerTest.assertNotNull((Object)data);
        ManagedCircuitBreakerLoadBalancerTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedCircuitBreakerLoadBalancerTest.assertNotNull((Object)data);
        ManagedCircuitBreakerLoadBalancerTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedCircuitBreakerLoadBalancerTest.assertNotNull((Object)data);
        ManagedCircuitBreakerLoadBalancerTest.assertEquals((int)5, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedCircuitBreakerLoadBalancerTest.assertNotNull((Object)json);
        ManagedCircuitBreakerLoadBalancerTest.assertTrue((boolean)json.contains("\"description\": \"Balances message processing among a number of nodes"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((LoadBalanceDefinition)this.from("direct:start").loadBalance().circuitBreaker(2, 5000L, new Class[]{IOException.class, SQLException.class}).id("mysend")).to("mock:foo");
            }
        };
    }
}

