/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.Predicate;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ChoiceDefinition;

public class ManagedChoiceTest
extends ManagementTestSupport {
    public void testManageChoice() throws Exception {
        if (ManagedChoiceTest.isPlatform("aix")) {
            return;
        }
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "foo", (Object)"456");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hi World", "bar", (Object)"789");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedChoiceTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedChoiceTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedChoiceTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        TabularData data = (TabularData)mbeanServer.invoke(on, "choiceStatistics", null, null);
        ManagedChoiceTest.assertNotNull((Object)data);
        ManagedChoiceTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedChoiceTest.assertNotNull((Object)data);
        ManagedChoiceTest.assertEquals((int)3, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedChoiceTest.assertNotNull((Object)data);
        ManagedChoiceTest.assertEquals((int)4, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedChoiceTest.assertNotNull((Object)json);
        ManagedChoiceTest.assertTrue((boolean)json.contains("\"description\": \"Routes messages based on a series of predicates"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().id("mysend")).when((Predicate)this.header("foo")).to("mock:foo")).otherwise().to("mock:bar");
            }
        };
    }
}

