/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class JmxInstrumentationOnlyRegisterProcessorWithCustomIdTest
extends ContextTestSupport {
    protected String domainName = "org.apache.camel";
    protected MBeanServer server;

    @Override
    protected boolean useJmx() {
        return true;
    }

    public void testCustomId() throws Exception {
        if (JmxInstrumentationOnlyRegisterProcessorWithCustomIdTest.isPlatform("aix")) {
            return;
        }
        Set<ObjectName> s = this.server.queryNames(new ObjectName(this.domainName + ":type=endpoints,*"), null);
        JmxInstrumentationOnlyRegisterProcessorWithCustomIdTest.assertEquals((String)("Could not find 2 endpoints: " + s), (int)6, (int)s.size());
        s = this.server.queryNames(new ObjectName(this.domainName + ":type=context,*"), null);
        JmxInstrumentationOnlyRegisterProcessorWithCustomIdTest.assertEquals((String)("Could not find 1 context: " + s), (int)1, (int)s.size());
        s = this.server.queryNames(new ObjectName(this.domainName + ":type=processors,*"), null);
        JmxInstrumentationOnlyRegisterProcessorWithCustomIdTest.assertEquals((String)("Could not find 1 processor: " + s), (int)1, (int)s.size());
        ObjectName on = s.iterator().next();
        String id = (String)this.server.getAttribute(on, "ProcessorId");
        JmxInstrumentationOnlyRegisterProcessorWithCustomIdTest.assertEquals((String)"myfoo", (String)id);
        s = this.server.queryNames(new ObjectName(this.domainName + ":type=routes,*"), null);
        JmxInstrumentationOnlyRegisterProcessorWithCustomIdTest.assertEquals((String)("Could not find 2 route: " + s), (int)2, (int)s.size());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().getManagementAgent().setOnlyRegisterProcessorWithCustomId(Boolean.valueOf(true));
        return context;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.server = ManagementFactory.getPlatformMBeanServer();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).id("myfoo")).delay(10L).to("mock:result");
                ((RouteDefinition)this.from("direct:other").to("mock:bar")).delay(10L).to("mock:other");
            }
        };
    }
}

