/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.spi.ThreadPoolProfile;

public class DualManagedThreadPoolProfileTest
extends ManagementTestSupport {
    public void testManagedThreadPool() throws Exception {
        if (DualManagedThreadPoolProfileTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=threadpools,name=\"threads1(threads)\"");
        Integer corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        DualManagedThreadPoolProfileTest.assertEquals((int)5, (int)corePoolSize);
        Integer maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        DualManagedThreadPoolProfileTest.assertEquals((int)15, (int)maxPoolSize);
        String id = (String)mbeanServer.getAttribute(on, "Id");
        DualManagedThreadPoolProfileTest.assertEquals((String)"threads1", (String)id);
        String source = (String)mbeanServer.getAttribute(on, "SourceId");
        DualManagedThreadPoolProfileTest.assertEquals((String)"threads", (String)source);
        String route = (String)mbeanServer.getAttribute(on, "RouteId");
        DualManagedThreadPoolProfileTest.assertEquals((String)"route1", (String)route);
        String profile = (String)mbeanServer.getAttribute(on, "ThreadPoolProfileId");
        DualManagedThreadPoolProfileTest.assertEquals((String)"custom", (String)profile);
        on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=threadpools,name=\"threads2(threads)\"");
        corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        DualManagedThreadPoolProfileTest.assertEquals((int)5, (int)corePoolSize);
        maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        DualManagedThreadPoolProfileTest.assertEquals((int)15, (int)maxPoolSize);
        id = (String)mbeanServer.getAttribute(on, "Id");
        DualManagedThreadPoolProfileTest.assertEquals((String)"threads2", (String)id);
        source = (String)mbeanServer.getAttribute(on, "SourceId");
        DualManagedThreadPoolProfileTest.assertEquals((String)"threads", (String)source);
        route = (String)mbeanServer.getAttribute(on, "RouteId");
        DualManagedThreadPoolProfileTest.assertEquals((String)"route2", (String)route);
        profile = (String)mbeanServer.getAttribute(on, "ThreadPoolProfileId");
        DualManagedThreadPoolProfileTest.assertEquals((String)"custom", (String)profile);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ThreadPoolProfile profile = new ThreadPoolProfile("custom");
                profile.setPoolSize(Integer.valueOf(5));
                profile.setMaxPoolSize(Integer.valueOf(15));
                profile.setKeepAliveTime(Long.valueOf(25L));
                profile.setMaxQueueSize(Integer.valueOf(250));
                profile.setRejectedPolicy(ThreadPoolRejectedPolicy.Abort);
                DualManagedThreadPoolProfileTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(profile);
                this.from("direct:start").threads().executorServiceRef("custom").to("mock:result");
                this.from("direct:foo").threads().executorServiceRef("custom").to("mock:foo");
            }
        };
    }
}

