/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;

public class BacklogDebuggerTest
extends ManagementTestSupport {
    public void testBacklogDebugger() throws Exception {
        if (BacklogDebuggerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=camel-1,type=tracer,name=BacklogDebugger");
        BacklogDebuggerTest.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogDebuggerTest.assertEquals((String)"Should not be enabled", (Object)Boolean.FALSE, (Object)enabled);
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogDebuggerTest.assertEquals((String)"Should be enabled", (Object)Boolean.TRUE, (Object)enabled);
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(1000L);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)1, (int)nodes.size());
        BacklogDebuggerTest.assertEquals((String)"bar", (String)((String)nodes.iterator().next()));
        String xml = (String)mbeanServer.invoke(on, "dumpTracedMessagesAsXml", new Object[]{"bar"}, new String[]{"java.lang.String"});
        BacklogDebuggerTest.assertNotNull((Object)xml);
        this.log.info(xml);
        BacklogDebuggerTest.assertTrue((String)"Should contain our body", (boolean)xml.contains("Hello World"));
        BacklogDebuggerTest.assertTrue((String)"Should contain bar node", (boolean)xml.contains("<toNode>bar</toNode>"));
        this.resetMocks();
        mock.expectedMessageCount(1);
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        this.assertMockEndpointsSatisfied();
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)0, (int)nodes.size());
    }

    public void testBacklogDebuggerUpdateBodyAndHeader() throws Exception {
        if (BacklogDebuggerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=camel-1,type=tracer,name=BacklogDebugger");
        BacklogDebuggerTest.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogDebuggerTest.assertEquals((String)"Should not be enabled", (Object)Boolean.FALSE, (Object)enabled);
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogDebuggerTest.assertEquals((String)"Should be enabled", (Object)Boolean.TRUE, (Object)enabled);
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(1000L);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)1, (int)nodes.size());
        BacklogDebuggerTest.assertEquals((String)"foo", (String)((String)nodes.iterator().next()));
        mbeanServer.invoke(on, "setMessageBodyOnBreakpoint", new Object[]{"foo", "Changed body"}, new String[]{"java.lang.String", "java.lang.Object"});
        mbeanServer.invoke(on, "setMessageHeaderOnBreakpoint", new Object[]{"foo", "beer", "Carlsberg"}, new String[]{"java.lang.String", "java.lang.String", "java.lang.Object"});
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        Thread.sleep(1000L);
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)1, (int)nodes.size());
        BacklogDebuggerTest.assertEquals((String)"bar", (String)((String)nodes.iterator().next()));
        String xml = (String)mbeanServer.invoke(on, "dumpTracedMessagesAsXml", new Object[]{"bar"}, new String[]{"java.lang.String"});
        BacklogDebuggerTest.assertNotNull((Object)xml);
        this.log.info(xml);
        BacklogDebuggerTest.assertTrue((String)"Should contain our body", (boolean)xml.contains("Changed body"));
        BacklogDebuggerTest.assertTrue((String)"Should contain bar node", (boolean)xml.contains("<toNode>bar</toNode>"));
        BacklogDebuggerTest.assertTrue((String)"Should contain our added header", (boolean)xml.contains("<header key=\"beer\" type=\"java.lang.String\">Carlsberg</header>"));
        this.resetMocks();
        mock.expectedMessageCount(1);
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        this.assertMockEndpointsSatisfied();
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)0, (int)nodes.size());
    }

    public void testBacklogDebuggerUpdateBodyAndHeaderType() throws Exception {
        if (BacklogDebuggerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=camel-1,type=tracer,name=BacklogDebugger");
        BacklogDebuggerTest.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogDebuggerTest.assertEquals((String)"Should not be enabled", (Object)Boolean.FALSE, (Object)enabled);
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogDebuggerTest.assertEquals((String)"Should be enabled", (Object)Boolean.TRUE, (Object)enabled);
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(1000L);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)1, (int)nodes.size());
        BacklogDebuggerTest.assertEquals((String)"foo", (String)((String)nodes.iterator().next()));
        mbeanServer.invoke(on, "setMessageBodyOnBreakpoint", new Object[]{"foo", "444", "java.lang.Integer"}, new String[]{"java.lang.String", "java.lang.Object", "java.lang.String"});
        mbeanServer.invoke(on, "setMessageHeaderOnBreakpoint", new Object[]{"foo", "beer", "123", "java.lang.Integer"}, new String[]{"java.lang.String", "java.lang.String", "java.lang.Object", "java.lang.String"});
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        Thread.sleep(1000L);
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)1, (int)nodes.size());
        BacklogDebuggerTest.assertEquals((String)"bar", (String)((String)nodes.iterator().next()));
        String xml = (String)mbeanServer.invoke(on, "dumpTracedMessagesAsXml", new Object[]{"bar"}, new String[]{"java.lang.String"});
        BacklogDebuggerTest.assertNotNull((Object)xml);
        this.log.info(xml);
        BacklogDebuggerTest.assertTrue((String)"Should contain our body", (boolean)xml.contains("444"));
        BacklogDebuggerTest.assertTrue((String)"Should contain bar node", (boolean)xml.contains("<toNode>bar</toNode>"));
        BacklogDebuggerTest.assertTrue((String)"Should contain our added header", (boolean)xml.contains("<header key=\"beer\" type=\"java.lang.Integer\">123</header>"));
        this.resetMocks();
        mock.expectedMessageCount(1);
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        this.assertMockEndpointsSatisfied();
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)0, (int)nodes.size());
    }

    public void testBacklogDebuggerRemoveBodyAndHeader() throws Exception {
        if (BacklogDebuggerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=camel-1,type=tracer,name=BacklogDebugger");
        BacklogDebuggerTest.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogDebuggerTest.assertEquals((String)"Should not be enabled", (Object)Boolean.FALSE, (Object)enabled);
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogDebuggerTest.assertEquals((String)"Should be enabled", (Object)Boolean.TRUE, (Object)enabled);
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(1000L);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)1, (int)nodes.size());
        BacklogDebuggerTest.assertEquals((String)"foo", (String)((String)nodes.iterator().next()));
        mbeanServer.invoke(on, "removeMessageBodyOnBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        mbeanServer.invoke(on, "removeMessageHeaderOnBreakpoint", new Object[]{"foo", "beer"}, new String[]{"java.lang.String", "java.lang.String"});
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        Thread.sleep(1000L);
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)1, (int)nodes.size());
        BacklogDebuggerTest.assertEquals((String)"bar", (String)((String)nodes.iterator().next()));
        String xml = (String)mbeanServer.invoke(on, "dumpTracedMessagesAsXml", new Object[]{"bar"}, new String[]{"java.lang.String"});
        BacklogDebuggerTest.assertNotNull((Object)xml);
        this.log.info(xml);
        BacklogDebuggerTest.assertTrue((String)"Should not contain our body", (boolean)xml.contains("<body>[Body is null]</body>"));
        BacklogDebuggerTest.assertTrue((String)"Should contain bar node", (boolean)xml.contains("<toNode>bar</toNode>"));
        BacklogDebuggerTest.assertFalse((String)"Should not contain any headers", (boolean)xml.contains("<header"));
        this.resetMocks();
        mock.expectedMessageCount(1);
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        this.assertMockEndpointsSatisfied();
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)0, (int)nodes.size());
    }

    public void testBacklogDebuggerSuspendOnlyOneAtBreakpoint() throws Exception {
        if (BacklogDebuggerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=camel-1,type=tracer,name=BacklogDebugger");
        BacklogDebuggerTest.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogDebuggerTest.assertEquals((String)"Should not be enabled", (Object)Boolean.FALSE, (Object)enabled);
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogDebuggerTest.assertEquals((String)"Should be enabled", (Object)Boolean.TRUE, (Object)enabled);
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.template.sendBody("seda:start", (Object)"Hello Camel");
        this.template.sendBody("seda:start", (Object)"Hello Earth");
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)1, (int)nodes.size());
        BacklogDebuggerTest.assertEquals((String)"bar", (String)((String)nodes.iterator().next()));
        String xml = (String)mbeanServer.invoke(on, "dumpTracedMessagesAsXml", new Object[]{"bar"}, new String[]{"java.lang.String"});
        BacklogDebuggerTest.assertNotNull((Object)xml);
        this.log.info(xml);
        BacklogDebuggerTest.assertTrue((String)"Should contain bar node", (boolean)xml.contains("<toNode>bar</toNode>"));
        this.resetMocks();
        mock.expectedMessageCount(1);
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        this.assertMockEndpointsSatisfied();
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)0, (int)nodes.size());
    }

    public void testBacklogDebuggerConditional() throws Exception {
        if (BacklogDebuggerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=camel-1,type=tracer,name=BacklogDebugger");
        BacklogDebuggerTest.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogDebuggerTest.assertEquals((String)"Should not be enabled", (Object)Boolean.FALSE, (Object)enabled);
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogDebuggerTest.assertEquals((String)"Should be enabled", (Object)Boolean.TRUE, (Object)enabled);
        Object out = mbeanServer.invoke(on, "validateConditionalBreakpoint", new Object[]{"unknown", "${body contains 'Camel'"}, new String[]{"java.lang.String", "java.lang.String"});
        BacklogDebuggerTest.assertEquals((Object)"No language could be found for: unknown", (Object)out);
        out = mbeanServer.invoke(on, "validateConditionalBreakpoint", new Object[]{"simple", "${body contains 'Camel'"}, new String[]{"java.lang.String", "java.lang.String"});
        BacklogDebuggerTest.assertNotNull((Object)out);
        BacklogDebuggerTest.assertTrue((boolean)out.toString().startsWith("Invalid syntax ${body contains 'Camel'"));
        out = mbeanServer.invoke(on, "validateConditionalBreakpoint", new Object[]{"simple", "${body} contains 'Camel'"}, new String[]{"java.lang.String", "java.lang.String"});
        BacklogDebuggerTest.assertNull((Object)out);
        mbeanServer.invoke(on, "addConditionalBreakpoint", new Object[]{"bar", "simple", "${body} contains 'Camel'"}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)0, (int)nodes.size());
        this.resetMocks();
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(1000L);
        this.template.sendBody("seda:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)1, (int)nodes.size());
        BacklogDebuggerTest.assertEquals((String)"bar", (String)((String)nodes.iterator().next()));
        String xml = (String)mbeanServer.invoke(on, "dumpTracedMessagesAsXml", new Object[]{"bar"}, new String[]{"java.lang.String"});
        BacklogDebuggerTest.assertNotNull((Object)xml);
        this.log.info(xml);
        BacklogDebuggerTest.assertTrue((String)"Should contain our body", (boolean)xml.contains("Hello Camel"));
        BacklogDebuggerTest.assertTrue((String)"Should contain bar node", (boolean)xml.contains("<toNode>bar</toNode>"));
        this.resetMocks();
        mock.expectedMessageCount(1);
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        this.assertMockEndpointsSatisfied();
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)0, (int)nodes.size());
    }

    public void testBacklogDebuggerStep() throws Exception {
        if (BacklogDebuggerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=camel-1,type=tracer,name=BacklogDebugger");
        BacklogDebuggerTest.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogDebuggerTest.assertEquals((String)"Should not be enabled", (Object)Boolean.FALSE, (Object)enabled);
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogDebuggerTest.assertEquals((String)"Should be enabled", (Object)Boolean.TRUE, (Object)enabled);
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(1000L);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)1, (int)nodes.size());
        BacklogDebuggerTest.assertEquals((String)"foo", (String)((String)nodes.iterator().next()));
        Boolean stepMode = (Boolean)mbeanServer.getAttribute(on, "SingleStepMode");
        BacklogDebuggerTest.assertEquals((String)"Should not be in step mode", (Object)Boolean.FALSE, (Object)stepMode);
        mbeanServer.invoke(on, "stepBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        Thread.sleep(1000L);
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)1, (int)nodes.size());
        BacklogDebuggerTest.assertEquals((String)"bar", (String)((String)nodes.iterator().next()));
        stepMode = (Boolean)mbeanServer.getAttribute(on, "SingleStepMode");
        BacklogDebuggerTest.assertEquals((String)"Should be in step mode", (Object)Boolean.TRUE, (Object)stepMode);
        mbeanServer.invoke(on, "step", null, null);
        Thread.sleep(1000L);
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)1, (int)nodes.size());
        BacklogDebuggerTest.assertEquals((String)"transform", (String)((String)nodes.iterator().next()));
        stepMode = (Boolean)mbeanServer.getAttribute(on, "SingleStepMode");
        BacklogDebuggerTest.assertEquals((String)"Should be in step mode", (Object)Boolean.TRUE, (Object)stepMode);
        mbeanServer.invoke(on, "step", null, null);
        Thread.sleep(1000L);
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)1, (int)nodes.size());
        BacklogDebuggerTest.assertEquals((String)"cheese", (String)((String)nodes.iterator().next()));
        stepMode = (Boolean)mbeanServer.getAttribute(on, "SingleStepMode");
        BacklogDebuggerTest.assertEquals((String)"Should be in step mode", (Object)Boolean.TRUE, (Object)stepMode);
        mbeanServer.invoke(on, "step", null, null);
        Thread.sleep(1000L);
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)1, (int)nodes.size());
        BacklogDebuggerTest.assertEquals((String)"result", (String)((String)nodes.iterator().next()));
        stepMode = (Boolean)mbeanServer.getAttribute(on, "SingleStepMode");
        BacklogDebuggerTest.assertEquals((String)"Should be in step mode", (Object)Boolean.TRUE, (Object)stepMode);
        mbeanServer.invoke(on, "step", null, null);
        Thread.sleep(1000L);
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)0, (int)nodes.size());
        stepMode = (Boolean)mbeanServer.getAttribute(on, "SingleStepMode");
        BacklogDebuggerTest.assertEquals((String)"Should not be in step mode", (Object)Boolean.FALSE, (Object)stepMode);
    }

    public void testBacklogDebuggerStepCurrentNode() throws Exception {
        if (BacklogDebuggerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=camel-1,type=tracer,name=BacklogDebugger");
        BacklogDebuggerTest.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogDebuggerTest.assertEquals((String)"Should not be enabled", (Object)Boolean.FALSE, (Object)enabled);
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogDebuggerTest.assertEquals((String)"Should be enabled", (Object)Boolean.TRUE, (Object)enabled);
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(1000L);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)1, (int)nodes.size());
        BacklogDebuggerTest.assertEquals((String)"foo", (String)((String)nodes.iterator().next()));
        Boolean stepMode = (Boolean)mbeanServer.getAttribute(on, "SingleStepMode");
        BacklogDebuggerTest.assertEquals((String)"Should not be in step mode", (Object)Boolean.FALSE, (Object)stepMode);
        mbeanServer.invoke(on, "stepBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        Thread.sleep(1000L);
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)1, (int)nodes.size());
        BacklogDebuggerTest.assertEquals((String)"bar", (String)((String)nodes.iterator().next()));
        stepMode = (Boolean)mbeanServer.getAttribute(on, "SingleStepMode");
        BacklogDebuggerTest.assertEquals((String)"Should be in step mode", (Object)Boolean.TRUE, (Object)stepMode);
        mbeanServer.invoke(on, "stepBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        Thread.sleep(1000L);
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)1, (int)nodes.size());
        BacklogDebuggerTest.assertEquals((String)"transform", (String)((String)nodes.iterator().next()));
        stepMode = (Boolean)mbeanServer.getAttribute(on, "SingleStepMode");
        BacklogDebuggerTest.assertEquals((String)"Should be in step mode", (Object)Boolean.TRUE, (Object)stepMode);
        mbeanServer.invoke(on, "stepBreakpoint", new Object[]{"transform"}, new String[]{"java.lang.String"});
        Thread.sleep(1000L);
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)1, (int)nodes.size());
        BacklogDebuggerTest.assertEquals((String)"cheese", (String)((String)nodes.iterator().next()));
        stepMode = (Boolean)mbeanServer.getAttribute(on, "SingleStepMode");
        BacklogDebuggerTest.assertEquals((String)"Should be in step mode", (Object)Boolean.TRUE, (Object)stepMode);
        mbeanServer.invoke(on, "stepBreakpoint", new Object[]{"cheese"}, new String[]{"java.lang.String"});
        Thread.sleep(1000L);
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)1, (int)nodes.size());
        BacklogDebuggerTest.assertEquals((String)"result", (String)((String)nodes.iterator().next()));
        stepMode = (Boolean)mbeanServer.getAttribute(on, "SingleStepMode");
        BacklogDebuggerTest.assertEquals((String)"Should be in step mode", (Object)Boolean.TRUE, (Object)stepMode);
        mbeanServer.invoke(on, "stepBreakpoint", new Object[]{"result"}, new String[]{"java.lang.String"});
        Thread.sleep(1000L);
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        BacklogDebuggerTest.assertNotNull((Object)nodes);
        BacklogDebuggerTest.assertEquals((int)0, (int)nodes.size());
        stepMode = (Boolean)mbeanServer.getAttribute(on, "SingleStepMode");
        BacklogDebuggerTest.assertEquals((String)"Should not be in step mode", (Object)Boolean.FALSE, (Object)stepMode);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                BacklogDebuggerTest.this.context.setUseBreadcrumb(Boolean.valueOf(false));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((ProcessorDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:start?concurrentConsumers=2").to("log:foo")).id("foo")).to("log:bar")).id("bar")).transform().constant((Object)"Bye World")).id("transform")).to("log:cheese?showExchangeId=true")).id("cheese")).to("mock:result")).id("result");
            }
        };
    }
}

