/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.tokenizer;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.SplitDefinition;

public class XMLTokenizeLanguageTest
extends ContextTestSupport {
    public void testSendClosedTagMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<c:child some_attr='a' anotherAttr='a' xmlns:c=\"urn:c\"></c:child>", "<c:child some_attr='b' anotherAttr='b' xmlns:c=\"urn:c\"></c:child>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c'><c:child some_attr='a' anotherAttr='a'></c:child><c:child some_attr='b' anotherAttr='b'></c:child></c:parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendClosedTagWithLineBreaksMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<c:child some_attr='a' anotherAttr='a' xmlns:c=\"urn:c\">\n</c:child>", "<c:child some_attr='b' anotherAttr='b' xmlns:c=\"urn:c\">\n</c:child>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?>\n<c:parent xmlns:c='urn:c'>\n<c:child some_attr='a' anotherAttr='a'>\n</c:child>\n<c:child some_attr='b' anotherAttr='b'>\n</c:child>\n</c:parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendSelfClosingTagMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<c:child some_attr='a' anotherAttr='a'  xmlns:c=\"urn:c\"/>", "<c:child some_attr='b' anotherAttr='b'  xmlns:c=\"urn:c\"/>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c'><c:child some_attr='a' anotherAttr='a' /><c:child some_attr='b' anotherAttr='b' /></c:parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendMixedClosingTagMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<c:child some_attr='a' anotherAttr='a' xmlns:c=\"urn:c\">ha</c:child>", "<c:child some_attr='b' anotherAttr='b'  xmlns:c=\"urn:c\"/>", "<c:child some_attr='c' xmlns:c=\"urn:c\"></c:child>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c'><c:child some_attr='a' anotherAttr='a'>ha</c:child><c:child some_attr='b' anotherAttr='b' /><c:child some_attr='c'></c:child></c:parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendMixedClosingTagInsideMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<c:child name='child1' xmlns:c=\"urn:c\"><grandchild name='grandchild1'/> <grandchild name='grandchild2'/></c:child>", "<c:child name='child2' xmlns:c=\"urn:c\"><grandchild name='grandchild1'></grandchild><grandchild name='grandchild2'></grandchild></c:child>"});
        this.template.sendBody("direct:start", (Object)"<c:parent xmlns:c='urn:c'><c:child name='child1'><grandchild name='grandchild1'/> <grandchild name='grandchild2'/></c:child><c:child name='child2'><grandchild name='grandchild1'></grandchild><grandchild name='grandchild2'></grandchild></c:child></c:parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendNamespacedChildMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<c:child xmlns:c='urn:c' some_attr='a' anotherAttr='a'></c:child>", "<c:child xmlns:c='urn:c' some_attr='b' anotherAttr='b' />"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c'><c:child xmlns:c='urn:c' some_attr='a' anotherAttr='a'></c:child><c:child xmlns:c='urn:c' some_attr='b' anotherAttr='b' /></c:parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendNamespacedParentMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<c:child some_attr='a' anotherAttr='a' xmlns:d=\"urn:d\" xmlns:c=\"urn:c\"></c:child>", "<c:child some_attr='b' anotherAttr='b' xmlns:d=\"urn:d\" xmlns:c=\"urn:c\"/>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c' xmlns:d=\"urn:d\"><c:child some_attr='a' anotherAttr='a'></c:child><c:child some_attr='b' anotherAttr='b'/></c:parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendMoreParentsMessageToTokenize() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        if (XMLTokenizeLanguageTest.isJavaVersion("1.8")) {
            result.expectedBodiesReceived(new Object[]{"<c:child some_attr='a' anotherAttr='a' xmlns:c=\"urn:c\" xmlns:d=\"urn:d\" xmlns:g=\"urn:g\"></c:child>", "<c:child some_attr='b' anotherAttr='b' xmlns:c=\"urn:c\" xmlns:d=\"urn:d\" xmlns:g=\"urn:g\"/>"});
        } else {
            result.expectedBodiesReceived(new Object[]{"<c:child some_attr='a' anotherAttr='a' xmlns:g=\"urn:g\" xmlns:d=\"urn:d\" xmlns:c=\"urn:c\"></c:child>", "<c:child some_attr='b' anotherAttr='b' xmlns:g=\"urn:g\" xmlns:d=\"urn:d\" xmlns:c=\"urn:c\"/>"});
        }
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?><g:greatgrandparent xmlns:g='urn:g'><grandparent><uncle/><aunt>emma</aunt><c:parent xmlns:c='urn:c' xmlns:d=\"urn:d\"><c:child some_attr='a' anotherAttr='a'></c:child><c:child some_attr='b' anotherAttr='b'/></c:parent></grandparent></g:greatgrandparent>");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){
            Namespaces ns = new Namespaces("C", "urn:c");

            public void configure() {
                ((ExpressionNode)((SplitDefinition)this.from("direct:start").split().xtokenize("//C:child", this.ns)).to("mock:result")).end();
            }
        };
    }
}

