/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.ExchangeTestSupport;
import org.apache.camel.language.simple.SimpleExpressionParser;
import org.apache.camel.language.simple.types.SimpleIllegalSyntaxException;

public class SimpleParserExpressionInvalidTest
extends ExchangeTestSupport {
    public void testSimpleUnbalanceFunction() throws Exception {
        SimpleExpressionParser parser = new SimpleExpressionParser("${body is a nice day", true);
        try {
            parser.parseExpression();
            SimpleParserExpressionInvalidTest.fail((String)"Should thrown exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleParserExpressionInvalidTest.assertEquals((int)19, (int)e.getIndex());
        }
    }

    public void testSimpleNestedUnbalanceFunction() throws Exception {
        SimpleExpressionParser parser = new SimpleExpressionParser("${body${foo}", true);
        try {
            parser.parseExpression();
            SimpleParserExpressionInvalidTest.fail((String)"Should thrown exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleParserExpressionInvalidTest.assertEquals((int)11, (int)e.getIndex());
        }
    }

    public void testSimpleUnknownFunction() throws Exception {
        SimpleExpressionParser parser = new SimpleExpressionParser("Hello ${foo} how are you?", true);
        try {
            parser.parseExpression();
            SimpleParserExpressionInvalidTest.fail((String)"Should thrown exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleParserExpressionInvalidTest.assertEquals((int)6, (int)e.getIndex());
        }
    }

    public void testSimpleNestedUnknownFunction() throws Exception {
        SimpleExpressionParser parser = new SimpleExpressionParser("Hello ${bodyAs(${foo})} how are you?", true);
        try {
            parser.parseExpression().evaluate(this.exchange, String.class);
            SimpleParserExpressionInvalidTest.fail((String)"Should thrown exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleParserExpressionInvalidTest.assertEquals((int)15, (int)e.getIndex());
        }
    }

    public void testNoEndFunction() throws Exception {
        SimpleExpressionParser parser = new SimpleExpressionParser("Hello ${body", true);
        try {
            parser.parseExpression();
            SimpleParserExpressionInvalidTest.fail((String)"Should thrown exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleParserExpressionInvalidTest.assertEquals((int)11, (int)e.getIndex());
        }
    }
}

