/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import javax.naming.Context;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Header;
import org.apache.camel.LanguageTestSupport;
import org.apache.camel.Message;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.language.bean.BeanLanguage;

public class BeanTest
extends LanguageTestSupport {
    public void testSimpleExpressions() throws Exception {
        this.assertExpression("foo.cheese", "abc");
        this.assertExpression("foo?method=cheese", "abc");
    }

    public void testPredicates() throws Exception {
        this.assertPredicate("foo.isFooHeaderAbc");
        this.assertPredicate("foo?method=isFooHeaderAbc");
    }

    public void testBeanTypeExpression() throws Exception {
        Expression exp = BeanLanguage.bean(MyUser.class, null);
        Exchange exchange = this.createExchangeWithBody("Claus");
        Object result = exp.evaluate(exchange, Object.class);
        BeanTest.assertEquals((Object)"Hello Claus", (Object)result);
    }

    public void testBeanTypeAndMethodExpression() throws Exception {
        Expression exp = BeanLanguage.bean(MyUser.class, (String)"hello");
        Exchange exchange = this.createExchangeWithBody("Claus");
        Object result = exp.evaluate(exchange, Object.class);
        BeanTest.assertEquals((Object)"Hello Claus", (Object)result);
    }

    public void testBeanInstanceAndMethodExpression() throws Exception {
        MyUser user = new MyUser();
        Expression exp = BeanLanguage.bean((Object)user, (String)"hello");
        Exchange exchange = this.createExchangeWithBody("Claus");
        Object result = exp.evaluate(exchange, Object.class);
        BeanTest.assertEquals((Object)"Hello Claus", (Object)result);
    }

    public void testNoMethod() throws Exception {
        MyUser user = new MyUser();
        Expression exp = BeanLanguage.bean((Object)user, (String)"unknown");
        Exchange exchange = this.createExchangeWithBody("Claus");
        Object result = exp.evaluate(exchange, Object.class);
        BeanTest.assertNull((Object)result);
        BeanTest.assertNotNull((Object)exchange.getException());
        MethodNotFoundException e = BeanTest.assertIsInstanceOf(MethodNotFoundException.class, exchange.getException());
        BeanTest.assertSame((Object)user, (Object)e.getBean());
        BeanTest.assertEquals((String)"unknown", (String)e.getMethodName());
    }

    public void testNoMethodBeanLookup() throws Exception {
        Expression exp = BeanLanguage.bean((String)"foo.cake");
        Exchange exchange = this.createExchangeWithBody("Claus");
        Object result = exp.evaluate(exchange, Object.class);
        BeanTest.assertNull((Object)result);
        BeanTest.assertNotNull((Object)exchange.getException());
        MethodNotFoundException e = BeanTest.assertIsInstanceOf(MethodNotFoundException.class, exchange.getException());
        BeanTest.assertSame((Object)this.context.getRegistry().lookupByName("foo"), (Object)e.getBean());
        BeanTest.assertEquals((String)"cake", (String)e.getMethodName());
    }

    @Override
    protected String getLanguageName() {
        return "bean";
    }

    @Override
    protected Context createJndiContext() throws Exception {
        Context context = super.createJndiContext();
        context.bind("foo", (Object)new MyBean());
        return context;
    }

    public static class MyUser {
        public String hello(String name) {
            return "Hello " + name;
        }
    }

    public static class MyBean {
        public Object cheese(Exchange exchange) {
            Message in = exchange.getIn();
            return in.getHeader("foo");
        }

        public boolean isFooHeaderAbc(@Header(value="foo") String foo) {
            return "abc".equals(foo);
        }
    }
}

