/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.EventObject;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.management.event.ExchangeSentEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;

public class SentExchangeEventNotifierTwoIssueTest
extends ContextTestSupport {
    private MyNotifier notifier = new MyNotifier();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().addEventNotifier((EventNotifier)this.notifier);
        return context;
    }

    public void testExchangeSentNotifier() throws Exception {
        this.notifier.reset();
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        SentExchangeEventNotifierTwoIssueTest.assertEquals((String)"I was here", (String)out);
        SentExchangeEventNotifierTwoIssueTest.assertEquals((int)2, (int)this.notifier.getCounter());
    }

    public void testExchangeSentNotifierExchange() throws Exception {
        this.notifier.reset();
        Exchange out = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello World");
            }
        });
        SentExchangeEventNotifierTwoIssueTest.assertEquals((Object)"I was here", (Object)out.getIn().getBody());
        SentExchangeEventNotifierTwoIssueTest.assertEquals((int)2, (int)this.notifier.getCounter());
    }

    public void testExchangeSentNotifierManualExchange() throws Exception {
        this.notifier.reset();
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        this.template.send("direct:start", (Exchange)exchange);
        SentExchangeEventNotifierTwoIssueTest.assertEquals((Object)"I was here", (Object)exchange.getIn().getBody());
        SentExchangeEventNotifierTwoIssueTest.assertEquals((int)2, (int)this.notifier.getCounter());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getIn().setBody((Object)"I was here");
                    }
                })).to("mock:result");
            }
        };
    }

    private class MyNotifier
    extends EventNotifierSupport {
        private int counter;

        private MyNotifier() {
        }

        public void notify(EventObject event) throws Exception {
            ++this.counter;
        }

        public boolean isEnabled(EventObject event) {
            return event instanceof ExchangeSentEvent;
        }

        public int getCounter() {
            return this.counter;
        }

        public void reset() {
            this.counter = 0;
        }
    }
}

