/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class OnExceptionNotHandledNoFailureProcessorTest
extends ContextTestSupport {
    public void testOnException() throws Exception {
        this.getMockEndpoint("mock:end").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error"));
                this.onException(RuntimeException.class).handled(false);
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new RuntimeException("FAIL!");
                    }
                })).to("mock:end");
            }
        };
    }
}

