/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class MockValueBuilderIssueTest
extends ContextTestSupport {
    public void testMockValueBuilder() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).exchangeProperty("foo")).convertTo(String.class).contains((Object)"2");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testMockValueBuilderFail() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).exchangeProperty("foo")).convertTo(String.class).contains((Object)"4");
        this.template.sendBody("direct:start", (Object)"Hello World");
        try {
            this.assertMockEndpointsSatisfied();
            MockValueBuilderIssueTest.fail((String)"Should fail");
        }
        catch (Throwable e) {
            String s = "Assertion error at index 0 on mock mock://result with predicate: exchangeProperty(foo) contains 4 evaluated as: 123 contains 4";
            MockValueBuilderIssueTest.assertTrue((boolean)e.getMessage().startsWith(s));
        }
    }

    public void testMockValueBuilderNotSatisfied() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).exchangeProperty("foo")).convertTo(String.class).contains((Object)"4");
        this.template.sendBody("direct:start", (Object)"Hello World");
        mock.assertIsNotSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").setProperty("foo", (Expression)this.constant(123))).to("mock:result");
            }
        };
    }
}

