/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryDefinition;

public class CharlesSplitAndTryCatchRollbackIssueTest
extends ContextTestSupport {
    public void testSplitWithTryCatchAndRollbackOK() throws Exception {
        MockEndpoint split = this.getMockEndpoint("mock:split");
        MockEndpoint ile = this.getMockEndpoint("mock:ile");
        MockEndpoint exception = this.getMockEndpoint("mock:exception");
        split.expectedBodiesReceived(new Object[]{"A", "B", "C"});
        ile.expectedMessageCount(0);
        exception.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"A,B,C");
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitWithTryCatchAndRollbackILE() throws Exception {
        MockEndpoint split = this.getMockEndpoint("mock:split");
        MockEndpoint ile = this.getMockEndpoint("mock:ile");
        MockEndpoint exception = this.getMockEndpoint("mock:exception");
        split.expectedBodiesReceived(new Object[]{"A", "B", "C"});
        ile.expectedMessageCount(1);
        exception.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"A,B,Forced,C");
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitWithTryCatchAndRollbackException() throws Exception {
        MockEndpoint split = this.getMockEndpoint("mock:split");
        MockEndpoint ile = this.getMockEndpoint("mock:ile");
        MockEndpoint exception = this.getMockEndpoint("mock:exception");
        split.expectedBodiesReceived(new Object[]{"A", "B"});
        ile.expectedMessageCount(0);
        exception.expectedMessageCount(1);
        try {
            this.template.sendBody("direct:start", (Object)"A,B,Kaboom,C");
            CharlesSplitAndTryCatchRollbackIssueTest.fail((String)"Should thrown an exception");
        }
        catch (CamelExecutionException e) {
            CamelExchangeException ee = CharlesSplitAndTryCatchRollbackIssueTest.assertIsInstanceOf(CamelExchangeException.class, e.getCause());
            CharlesSplitAndTryCatchRollbackIssueTest.assertTrue((boolean)ee.getMessage().startsWith("Sequential processing failed for number 2."));
            RollbackExchangeException re = CharlesSplitAndTryCatchRollbackIssueTest.assertIsInstanceOf(RollbackExchangeException.class, ee.getCause());
            CharlesSplitAndTryCatchRollbackIssueTest.assertTrue((boolean)re.getMessage().startsWith("Intended rollback"));
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitWithTryCatchAndRollbacILEAndException() throws Exception {
        MockEndpoint split = this.getMockEndpoint("mock:split");
        MockEndpoint ile = this.getMockEndpoint("mock:ile");
        MockEndpoint exception = this.getMockEndpoint("mock:exception");
        split.expectedBodiesReceived(new Object[]{"A", "B"});
        ile.expectedMessageCount(1);
        exception.expectedMessageCount(1);
        try {
            this.template.sendBody("direct:start", (Object)"A,Forced,B,Kaboom,C");
            CharlesSplitAndTryCatchRollbackIssueTest.fail((String)"Should thrown an exception");
        }
        catch (CamelExecutionException e) {
            CamelExchangeException ee = CharlesSplitAndTryCatchRollbackIssueTest.assertIsInstanceOf(CamelExchangeException.class, e.getCause());
            CharlesSplitAndTryCatchRollbackIssueTest.assertTrue((boolean)ee.getMessage().startsWith("Sequential processing failed for number 3."));
            RollbackExchangeException re = CharlesSplitAndTryCatchRollbackIssueTest.assertIsInstanceOf(RollbackExchangeException.class, ee.getCause());
            CharlesSplitAndTryCatchRollbackIssueTest.assertTrue((boolean)re.getMessage().startsWith("Intended rollback"));
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").split((Expression)this.body().tokenize(",")).stopOnException().doTry().process((Processor)new MyProcessor())).to("mock:split")).doCatch(IllegalArgumentException.class).to("mock:ile")).doCatch(Exception.class).to("mock:exception")).rollback()).end();
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            if ("Forced".equals(body)) {
                throw new IllegalArgumentException("Forced");
            }
            if ("Kaboom".equals(body)) {
                throw new Exception("Kaboom");
            }
        }
    }
}

