/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.spi.InterceptStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdviceWithStartTargetIssueTest
extends ContextTestSupport {
    public void testAdvised() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, new RouteBuilder(){

            public void configure() throws Exception {
                ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("mock:foo").skipSendToOriginalEndpoint().to("log:foo")).to("mock:advised");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:advised").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.getContext().addInterceptStrategy((InterceptStrategy)new ContainerWideInterceptor());
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).to("mock:result");
            }
        };
    }

    static class ContainerWideInterceptor
    implements InterceptStrategy {
        private static final Logger LOG = LoggerFactory.getLogger(ContainerWideInterceptor.class);
        private static int count;

        ContainerWideInterceptor() {
        }

        public Processor wrapProcessorInInterceptors(CamelContext context, ProcessorDefinition<?> definition, final Processor target, Processor nextTarget) throws Exception {
            return new DelegateAsyncProcessor(new Processor(){

                public void process(Exchange exchange) throws Exception {
                    count++;
                    LOG.info("I am the container wide interceptor. Intercepted total count: " + count);
                    target.process(exchange);
                }

                public String toString() {
                    return "ContainerWideInterceptor[" + target + "]";
                }
            });
        }

        public int getCount() {
            return count;
        }
    }
}

