/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class AdviceWithInterceptTest
extends ContextTestSupport {
    public void testAdviceIntercept() throws Exception {
        this.getMockEndpoint("mock:advice").expectedMessageCount(1);
        this.context.getRouteDefinition("main").adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.weaveAddFirst().to("direct:advice");
            }
        });
        this.template.sendBody("direct:main", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.intercept().log("Intercept ${body}");
                ((RouteDefinition)this.from("direct:advice").log("Advice ${body}")).to("mock:advice");
                this.from("direct:main").routeId("main").log("Main ${body}");
            }
        };
    }
}

