/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Route;
import org.apache.camel.StatefulService;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class RouteSedaStopStartTest
extends ContextTestSupport {
    public void testStopStart() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A"});
        this.template.sendBody("seda:foo", (Object)"A");
        this.assertMockEndpointsSatisfied();
        this.log.info("Stopping");
        this.resetMocks();
        mock.expectedMessageCount(0);
        this.context.stopRoute("foo");
        RouteSedaStopStartTest.assertEquals((String)"Stopped", (String)this.context.getRouteStatus("foo").name());
        Route route = this.context.getRoute("foo");
        if (route instanceof StatefulService) {
            RouteSedaStopStartTest.assertEquals((String)"Stopped", (String)((StatefulService)route).getStatus().name());
        }
        this.template.sendBody("seda:foo", (Object)"B");
        mock.assertIsSatisfied(1000L);
        this.log.info("Starting");
        this.resetMocks();
        mock.expectedBodiesReceived(new Object[]{"B"});
        this.context.startRoute("foo");
        this.assertMockEndpointsSatisfied();
        RouteSedaStopStartTest.assertEquals((String)"Started", (String)this.context.getRouteStatus("foo").name());
        route = this.context.getRoute("foo");
        if (route instanceof StatefulService) {
            RouteSedaStopStartTest.assertEquals((String)"Started", (String)((StatefulService)route).getStatus().name());
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:foo").routeId("foo").to("log:foo")).to("mock:result");
            }
        };
    }
}

