/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.RoutePolicy;

public class RoutePolicyTest
extends ContextTestSupport {
    private MyRoutPolicy routePolicy = new MyRoutPolicy();

    public void testStartCalledWhenCamelStarts() throws Exception {
        RoutePolicyTest.assertEquals((int)1, (int)this.routePolicy.getStartCount());
    }

    public void testStartCalledWhenRouteStarts() throws Exception {
        RoutePolicyTest.assertEquals((int)1, (int)this.routePolicy.getStartCount());
        this.context.stopRoute("foo");
        this.context.startRoute("foo");
        RoutePolicyTest.assertEquals((int)2, (int)this.routePolicy.getStartCount());
    }

    public void testStopCalledWhenCamelStops() throws Exception {
        RoutePolicyTest.assertEquals((int)0, (int)this.routePolicy.getStopCount());
        this.stopCamelContext();
        RoutePolicyTest.assertEquals((int)1, (int)this.routePolicy.getStopCount());
    }

    public void testStopCalledWhenRouteStops() throws Exception {
        RoutePolicyTest.assertEquals((int)0, (int)this.routePolicy.getStopCount());
        this.context.stopRoute("foo");
        RoutePolicyTest.assertEquals((int)1, (int)this.routePolicy.getStopCount());
    }

    public void testSuspendCalledWhenRouteSuspends() throws Exception {
        RoutePolicyTest.assertEquals((int)0, (int)this.routePolicy.getSuspendCount());
        this.context.suspendRoute("foo");
        RoutePolicyTest.assertEquals((int)1, (int)this.routePolicy.getSuspendCount());
    }

    public void testResumeCalledWhenRouteResumes() throws Exception {
        RoutePolicyTest.assertEquals((int)0, (int)this.routePolicy.getResumeCount());
        this.context.suspendRoute("foo");
        this.context.resumeRoute("foo");
        RoutePolicyTest.assertEquals((int)1, (int)this.routePolicy.getResumeCount());
    }

    public void testRemoveCalledWhenRouteIsRemovedById() throws Exception {
        RoutePolicyTest.assertEquals((int)0, (int)this.routePolicy.getRemoveCount());
        this.context.stopRoute("foo");
        RoutePolicyTest.assertEquals((int)0, (int)this.routePolicy.getRemoveCount());
        this.context.removeRoute("foo");
        RoutePolicyTest.assertEquals((int)1, (int)this.routePolicy.getRemoveCount());
    }

    public void testRemoveCalledWhenCamelIsStopped() throws Exception {
        RoutePolicyTest.assertTrue((boolean)this.context.getStatus().isStarted());
        RoutePolicyTest.assertEquals((int)0, (int)this.routePolicy.getRemoveCount());
        this.context.stop();
        RoutePolicyTest.assertTrue((boolean)this.context.getStatus().isStopped());
        RoutePolicyTest.assertEquals((int)1, (int)this.routePolicy.getRemoveCount());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("foo").routePolicy(new RoutePolicy[]{RoutePolicyTest.this.routePolicy}).to("mock:result");
            }
        };
    }

    private class MyRoutPolicy
    implements RoutePolicy {
        private AtomicInteger removeCounter = new AtomicInteger();
        private AtomicInteger startCounter = new AtomicInteger();
        private AtomicInteger stopCounter = new AtomicInteger();
        private AtomicInteger suspendCounter = new AtomicInteger();
        private AtomicInteger resumeCounter = new AtomicInteger();

        private MyRoutPolicy() {
        }

        public void onRemove(Route route) {
            this.removeCounter.incrementAndGet();
        }

        public void onStart(Route route) {
            this.startCounter.incrementAndGet();
        }

        public void onStop(Route route) {
            this.stopCounter.incrementAndGet();
        }

        public void onSuspend(Route route) {
            this.suspendCounter.incrementAndGet();
        }

        public void onResume(Route route) {
            this.resumeCounter.incrementAndGet();
        }

        public void onInit(Route route) {
        }

        public void onExchangeBegin(Route route, Exchange exchange) {
        }

        public void onExchangeDone(Route route, Exchange exchange) {
        }

        private int getRemoveCount() {
            return this.removeCounter.get();
        }

        private int getStartCount() {
            return this.startCounter.get();
        }

        private int getStopCount() {
            return this.stopCounter.get();
        }

        private int getSuspendCount() {
            return this.suspendCounter.get();
        }

        private int getResumeCount() {
            return this.resumeCounter.get();
        }
    }
}

