/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.support.ExpressionAdapter;

public class ExpressionAdapterTest
extends ContextTestSupport {
    public void testExpressionAdapter() throws Exception {
        MyExpression my = new MyExpression();
        DefaultExchange e = new DefaultExchange((CamelContext)this.context);
        e.getIn().setBody((Object)"bar");
        my.assertMatches("bar", (Exchange)e);
    }

    public void testExpressionAdapterFail() throws Exception {
        MyExpression my = new MyExpression();
        DefaultExchange e = new DefaultExchange((CamelContext)this.context);
        e.getIn().setBody((Object)"Kabom");
        try {
            my.assertMatches("damn", (Exchange)e);
            ExpressionAdapterTest.fail((String)"Should have thrown exception");
        }
        catch (AssertionError ae) {
            ExpressionAdapterTest.assertTrue((boolean)((Throwable)((Object)ae)).getMessage().contains("foo"));
        }
    }

    private static class MyExpression
    extends ExpressionAdapter {
        private MyExpression() {
        }

        protected String assertionFailureMessage(Exchange exchange) {
            return "foo";
        }

        public <T> T evaluate(Exchange exchange, Class<T> type) {
            String in = (String)exchange.getIn().getBody(String.class);
            if ("Kabom".equals(in)) {
                return null;
            }
            return (T)in;
        }
    }
}

