/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class EndpointRegistryKeepRouteEndpointsTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getProperties().put("CamelMaximumEndpointCacheSize", "20");
        return context;
    }

    public void testEndpointRegistryKeepRouteEndpoints() throws Exception {
        EndpointRegistryKeepRouteEndpointsTest.assertTrue((this.context.hasEndpoint("direct://start") != null ? 1 : 0) != 0);
        EndpointRegistryKeepRouteEndpointsTest.assertTrue((this.context.hasEndpoint("log://foo") != null ? 1 : 0) != 0);
        EndpointRegistryKeepRouteEndpointsTest.assertTrue((this.context.hasEndpoint("log://bar") != null ? 1 : 0) != 0);
        EndpointRegistryKeepRouteEndpointsTest.assertTrue((this.context.hasEndpoint("mock://result") != null ? 1 : 0) != 0);
        EndpointRegistryKeepRouteEndpointsTest.assertFalse((this.context.hasEndpoint("mock://unknown0") != null ? 1 : 0) != 0);
        for (int i = 0; i < 50; ++i) {
            this.template.sendBody("mock:unknown" + i, (Object)("Hello " + i));
        }
        EndpointRegistryKeepRouteEndpointsTest.assertTrue((this.context.hasEndpoint("direct://start") != null ? 1 : 0) != 0);
        EndpointRegistryKeepRouteEndpointsTest.assertTrue((this.context.hasEndpoint("log://foo") != null ? 1 : 0) != 0);
        EndpointRegistryKeepRouteEndpointsTest.assertTrue((this.context.hasEndpoint("log://bar") != null ? 1 : 0) != 0);
        EndpointRegistryKeepRouteEndpointsTest.assertTrue((this.context.hasEndpoint("mock://result") != null ? 1 : 0) != 0);
        EndpointRegistryKeepRouteEndpointsTest.assertFalse((this.context.hasEndpoint("mock://unknown0") != null ? 1 : 0) != 0);
        EndpointRegistryKeepRouteEndpointsTest.assertFalse((this.context.hasEndpoint("mock://unknown1") != null ? 1 : 0) != 0);
        EndpointRegistryKeepRouteEndpointsTest.assertTrue((this.context.hasEndpoint("mock://unknown47") != null ? 1 : 0) != 0);
        EndpointRegistryKeepRouteEndpointsTest.assertTrue((this.context.hasEndpoint("mock://unknown48") != null ? 1 : 0) != 0);
        EndpointRegistryKeepRouteEndpointsTest.assertTrue((this.context.hasEndpoint("mock://unknown49") != null ? 1 : 0) != 0);
        EndpointRegistryKeepRouteEndpointsTest.assertEquals((int)4, (int)this.context.getEndpointRegistry().staticSize());
        EndpointRegistryKeepRouteEndpointsTest.assertTrue((boolean)this.context.getEndpointRegistry().isStatic("direct://start"));
        EndpointRegistryKeepRouteEndpointsTest.assertTrue((boolean)this.context.getEndpointRegistry().isDynamic("mock://unknown49"));
        EndpointRegistryKeepRouteEndpointsTest.assertEquals((int)20, (int)this.context.getEndpointRegistry().dynamicSize());
        EndpointRegistryKeepRouteEndpointsTest.assertEquals((int)24, (int)this.context.getEndpointRegistry().size());
        EndpointRegistryKeepRouteEndpointsTest.assertEquals((int)24, (int)this.context.getEndpoints().size());
        this.context.getEndpointRegistry().purge();
        EndpointRegistryKeepRouteEndpointsTest.assertEquals((int)4, (int)this.context.getEndpointRegistry().staticSize());
        EndpointRegistryKeepRouteEndpointsTest.assertEquals((int)0, (int)this.context.getEndpointRegistry().dynamicSize());
        EndpointRegistryKeepRouteEndpointsTest.assertEquals((int)4, (int)this.context.getEndpointRegistry().size());
        EndpointRegistryKeepRouteEndpointsTest.assertTrue((this.context.hasEndpoint("direct://start") != null ? 1 : 0) != 0);
        EndpointRegistryKeepRouteEndpointsTest.assertTrue((this.context.hasEndpoint("log://foo") != null ? 1 : 0) != 0);
        EndpointRegistryKeepRouteEndpointsTest.assertTrue((this.context.hasEndpoint("log://bar") != null ? 1 : 0) != 0);
        EndpointRegistryKeepRouteEndpointsTest.assertTrue((this.context.hasEndpoint("mock://result") != null ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:foo")).to("log:bar")).to("mock:result");
            }
        };
    }
}

