/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;

public class DefaultConsumerTemplateWithCustomCacheMaxSizeTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getProperties().put("CamelMaximumCachePoolSize", "200");
        return context;
    }

    public void testCacheConsumers() throws Exception {
        ConsumerTemplate template = this.context.createConsumerTemplate();
        DefaultConsumerTemplateWithCustomCacheMaxSizeTest.assertEquals((String)"Size should be 0", (int)0, (int)template.getCurrentCacheSize());
        for (int i = 0; i < 203; ++i) {
            Endpoint e = this.context.getEndpoint("direct:queue:" + i);
            template.receiveNoWait(e);
        }
        DefaultConsumerTemplateWithCustomCacheMaxSizeTest.assertEquals((String)"Size should be 200", (int)200, (int)template.getCurrentCacheSize());
        template.stop();
        DefaultConsumerTemplateWithCustomCacheMaxSizeTest.assertEquals((String)"Size should be 0", (int)0, (int)template.getCurrentCacheSize());
    }

    public void testInvalidSizeABC() {
        this.context.getProperties().put("CamelMaximumCachePoolSize", "ABC");
        try {
            this.context.createConsumerTemplate();
            DefaultConsumerTemplateWithCustomCacheMaxSizeTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            DefaultConsumerTemplateWithCustomCacheMaxSizeTest.assertEquals((String)"Property CamelMaximumCachePoolSize must be a positive number, was: ABC", (String)e.getMessage());
        }
    }

    public void testInvalidSizeZero() {
        this.context.getProperties().put("CamelMaximumCachePoolSize", "0");
        try {
            this.context.createConsumerTemplate();
            DefaultConsumerTemplateWithCustomCacheMaxSizeTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            DefaultConsumerTemplateWithCustomCacheMaxSizeTest.assertEquals((String)"Property CamelMaximumCachePoolSize must be a positive number, was: 0", (String)e.getMessage());
        }
    }
}

