/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.BeanInject;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelBeanPostProcessor;
import org.apache.camel.impl.FooBar;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class BeanInjectRouteBuilderTest
extends ContextTestSupport {
    @BeanInject
    private FooBar foo;

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new FooBar());
        return jndi;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        DefaultCamelBeanPostProcessor post = new DefaultCamelBeanPostProcessor(context);
        post.postProcessBeforeInitialization((Object)this, "MyRoute");
        post.postProcessAfterInitialization((Object)this, "MyRoute");
        return context;
    }

    public void testBeanInject() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String out = BeanInjectRouteBuilderTest.this.foo.hello((String)exchange.getIn().getBody(String.class));
                        exchange.getIn().setBody((Object)out);
                    }
                })).to("mock:result");
            }
        };
    }
}

