/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.xslt.XsltOutput;
import org.apache.camel.model.RouteDefinition;

public class ManagedXsltOutputBytesTest
extends ContextTestSupport {
    @Override
    protected boolean useJmx() {
        return true;
    }

    protected MBeanServer getMBeanServer() {
        return this.context.getManagementStrategy().getManagementAgent().getMBeanServer();
    }

    public void testXsltOutput() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        ((ValueBuilder)mock.message(0).body()).isInstanceOf(byte[].class);
        this.template.sendBody("direct:start", (Object)"<hello>world!</hello>");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"xslt://org/apache/camel/component/xslt/example.xsl\\?output=bytes\"");
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        ManagedXsltOutputBytesTest.assertEquals((String)"xslt://org/apache/camel/component/xslt/example.xsl?output=bytes", (String)uri);
        Boolean saxon = (Boolean)mbeanServer.getAttribute(on, "Saxon");
        ManagedXsltOutputBytesTest.assertEquals((boolean)false, (boolean)saxon);
        XsltOutput output = (XsltOutput)mbeanServer.getAttribute(on, "Output");
        ManagedXsltOutputBytesTest.assertEquals((Object)XsltOutput.bytes, (Object)output);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedXsltOutputBytesTest.assertEquals((String)"Started", (String)state);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("xslt:org/apache/camel/component/xslt/example.xsl?output=bytes")).to("mock:result");
            }
        };
    }
}

