/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vm;

import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;

public class VmMultipleConsumersKeepRouteTest
extends TestCase {
    public void testVmMultipleConsumersKeepRoute() throws Exception {
        DefaultCamelContext camelContext = new DefaultCamelContext();
        ProducerTemplate producerTemplate = camelContext.createProducerTemplate();
        RouteBuilder builder = new RouteBuilder((CamelContext)camelContext){

            public void configure() throws Exception {
                this.from("vm:producer?multipleConsumers=true").routeId("route1").to("mock:route1");
            }
        };
        RouteBuilder builder2 = new RouteBuilder((CamelContext)camelContext){

            public void configure() throws Exception {
                this.from("vm:producer?multipleConsumers=true").routeId("route2").to("mock:route2");
            }
        };
        camelContext.addRoutes((RoutesBuilder)builder);
        camelContext.addRoutes((RoutesBuilder)builder2);
        camelContext.start();
        MockEndpoint mock1 = (MockEndpoint)camelContext.getEndpoint("mock:route1");
        MockEndpoint mock2 = (MockEndpoint)camelContext.getEndpoint("mock:route2");
        mock1.expectedMessageCount(100);
        mock2.expectedMessageCount(100);
        for (int i = 0; i < 100; ++i) {
            producerTemplate.sendBody("vm:producer?multipleConsumers=true", (Object)i);
        }
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{mock1, mock2});
        camelContext.stop();
    }
}

