/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.ActiveMQUuidGenerator;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;

public class DummyRestConsumerFactory
implements RestConsumerFactory,
RestApiConsumerFactory {
    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        String id = uriTemplate != null ? ActiveMQUuidGenerator.generateSanitizedId((String)(basePath + uriTemplate)) : ActiveMQUuidGenerator.generateSanitizedId((String)basePath);
        if (id.startsWith("-")) {
            id = id.substring(1);
        }
        SedaEndpoint seda = (SedaEndpoint)camelContext.getEndpoint("seda:" + verb + "-" + id, SedaEndpoint.class);
        return seda.createConsumer(processor);
    }

    public Consumer createApiConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        String id = ActiveMQUuidGenerator.generateSanitizedId((String)contextPath);
        if (id.startsWith("-")) {
            id = id.substring(1);
        }
        SedaEndpoint seda = (SedaEndpoint)camelContext.getEndpoint("seda:api:-" + id, SedaEndpoint.class);
        return seda.createConsumer(processor);
    }
}

