/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;

public class PropertiesRouteIdTest
extends ContextTestSupport {
    public void testPropertiesRouteId() throws Exception {
        PropertiesRouteIdTest.assertEquals((int)1, (int)this.context.getRoutes().size());
        PropertiesRouteIdTest.assertNotNull((String)"Route with name Camel should exist", (Object)this.context.getRoute("Camel"));
        String id = ((ProcessorDefinition)this.context.getRouteDefinition("Camel").getOutputs().get(0)).getId();
        PropertiesRouteIdTest.assertEquals((String)"{{cool.other.name}}", (String)id);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routeId("{{cool.name}}").to("mock:result")).id("{{cool.other.name}}");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.addComponent("properties", (Component)new PropertiesComponent("classpath:org/apache/camel/component/properties/myproperties.properties"));
        return context;
    }
}

