/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NamedNode;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SendDefinition;

public class PropertiesRouteFromTest
extends ContextTestSupport {
    public void testPropertiesRouteFrom() throws Exception {
        ProcessorDefinition out = (ProcessorDefinition)this.context.getRouteDefinition("foo").getOutputs().get(0);
        PropertiesRouteFromTest.assertEquals((String)"{{cool.end}}", (String)((SendDefinition)out).getUri());
        String uri = ((FromDefinition)this.context.getRouteDefinition("foo").getInputs().get(0)).getUri();
        PropertiesRouteFromTest.assertEquals((String)"{{cool.start}}", (String)uri);
        String xml = ModelHelper.dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("foo"));
        PropertiesRouteFromTest.assertTrue((boolean)xml.contains("<from uri=\"{{cool.start}}\"/>"));
        PropertiesRouteFromTest.assertTrue((boolean)xml.contains("<to uri=\"{{cool.end}}\""));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("{{cool.start}}").routeId("foo").to("{{cool.end}}");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.addComponent("properties", (Component)new PropertiesComponent("classpath:org/apache/camel/component/properties/myproperties.properties"));
        return context;
    }
}

