/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.RouteDefinition;

public class PropertiesComponentConcatenatePropertiesTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.addComponent("properties", (Component)new PropertiesComponent("classpath:org/apache/camel/component/properties/concatenation.properties"));
        return context;
    }

    @Override
    protected void setUp() throws Exception {
        System.setProperty("environment", "junit");
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        System.clearProperty("environment");
        super.tearDown();
    }

    public void testConcatPropertiesComponentDefault() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").setBody((Expression)this.simple("${properties:concat.property}"))).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"file:dirname"});
        this.template.sendBody("direct:start", (Object)"Test");
        this.assertMockEndpointsSatisfied();
    }

    public void testWithoutConcatPropertiesComponentDefault() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").setBody((Expression)this.simple("${properties:property.complete}"))).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"file:dirname"});
        this.template.sendBody("direct:start", (Object)"Test");
        this.assertMockEndpointsSatisfied();
    }
}

