/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import java.io.FileOutputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangedReadLockTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FileChangedReadLockTest.class);

    @Override
    protected void setUp() throws Exception {
        FileChangedReadLockTest.deleteDirectory("target/changed/");
        FileChangedReadLockTest.createDirectory("target/changed/in");
        super.setUp();
    }

    public void testChangedReadLock() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists("target/changed/out/slowfile.dat");
        this.writeSlowFile();
        this.assertMockEndpointsSatisfied();
        String content = (String)this.context.getTypeConverter().convertTo(String.class, (Object)new File("target/changed/out/slowfile.dat"));
        String[] lines = content.split(LS);
        FileChangedReadLockTest.assertEquals((String)"There should be 20 lines in the file", (int)20, (int)lines.length);
        for (int i = 0; i < 20; ++i) {
            FileChangedReadLockTest.assertEquals((String)("Line " + i), (String)lines[i]);
        }
    }

    private void writeSlowFile() throws Exception {
        LOG.debug("Writing slow file...");
        FileOutputStream fos = new FileOutputStream("target/changed/in/slowfile.dat");
        for (int i = 0; i < 20; ++i) {
            fos.write(("Line " + i + LS).getBytes());
            LOG.debug("Writing line " + i);
            Thread.sleep(200L);
        }
        fos.flush();
        fos.close();
        LOG.debug("Writing slow file DONE...");
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file:target/changed/in?readLock=changed").to(new String[]{"file:target/changed/out", "mock:result"});
            }
        };
    }
}

