/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.FileOutputStream;
import java.util.Date;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangedReadLockMinAgeShortCircuitTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FileChangedReadLockMinAgeShortCircuitTest.class);

    @Override
    protected void setUp() throws Exception {
        FileChangedReadLockMinAgeShortCircuitTest.deleteDirectory("target/changed/");
        FileChangedReadLockMinAgeShortCircuitTest.createDirectory("target/changed/in");
        this.writeFile();
        Thread.sleep(1000L);
        super.setUp();
    }

    public void testChangedReadLockMinAge() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists("target/changed/out/file.dat");
        mock.expectedMessagesMatches(new Predicate[]{FileChangedReadLockMinAgeShortCircuitTest.exchangeProperty("CamelReceivedTimestamp").convertTo(Long.TYPE).isLessThan((Object)(new Date().getTime() + 15000L))});
        this.assertMockEndpointsSatisfied();
    }

    private void writeFile() throws Exception {
        LOG.debug("Writing file...");
        FileOutputStream fos = new FileOutputStream("target/changed/in/file.dat");
        fos.write("Line".getBytes());
        fos.flush();
        fos.close();
        LOG.debug("Writing file DONE...");
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file:target/changed/in?readLock=changed&readLockMinAge=500&readLockCheckInterval=30000&readLockTimeout=90000").to(new String[]{"file:target/changed/out", "mock:result"});
            }
        };
    }
}

