/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileProducerRenameUsingCopyTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileProducerRenameUsingCopyTest.deleteDirectory("target/file");
        super.setUp();
    }

    public void testMove() throws Exception {
        String body = "Hello Camel";
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists("target/file/done/hello.txt", "Hello Camel");
        this.template.sendBodyAndHeader("file://target/file", (Object)"Hello Camel", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        FileProducerRenameUsingCopyTest.assertTrue((String)"File not copied", (boolean)new File("target/file/done/hello.txt").exists());
        FileProducerRenameUsingCopyTest.assertFalse((String)"File not deleted", (boolean)new File("target/file/hello.txt").exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/file?renameUsingCopy=true&move=done").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

