/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerIdempotentKeyChangedIssue2Test
extends ContextTestSupport {
    private Endpoint endpoint;

    public void testFile() throws Exception {
        this.getMockEndpoint("mock:file").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.endpoint, (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matches(5L, TimeUnit.SECONDS);
        this.resetMocks();
        this.getMockEndpoint("mock:file").expectedBodiesReceived(new Object[]{"Hello World Again"});
        Thread.sleep(250L);
        this.template.sendBodyAndHeader(this.endpoint, (Object)"Hello World Again", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                FileConsumerIdempotentKeyChangedIssue2Test.this.endpoint = this.endpoint("file:target/changed?noop=true&delay=100&idempotentKey=${file:name}-${file:size}-${file:modified}");
                ((RouteDefinition)((RouteDefinition)this.from(FileConsumerIdempotentKeyChangedIssue2Test.this.endpoint).convertBodyTo(String.class)).to("log:file")).to("mock:file");
            }
        };
    }
}

