/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerFailureHandledTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumerFailureHandledTest.deleteDirectory("target/messages/input");
        super.setUp();
    }

    public void testParis() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:valid");
        mock.expectedBodiesReceived(new Object[]{"Hello Paris"});
        this.template.sendBodyAndHeader("file:target/messages/input/", (Object)"Paris", "CamelFileName", (Object)"paris.txt");
        mock.assertIsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        FileConsumerFailureHandledTest.assertFiles("paris.txt", true);
    }

    public void testLondon() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:invalid");
        mock.expectedBodiesReceived(new Object[]{"London"});
        this.template.sendBodyAndHeader("file:target/messages/input/", (Object)"London", "CamelFileName", (Object)"london.txt");
        mock.assertIsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        FileConsumerFailureHandledTest.assertFiles("london.txt", true);
    }

    public void testDublin() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:beer");
        mock.expectedBodiesReceived(new Object[]{"Dublin"});
        this.template.sendBodyAndHeader("file:target/messages/input/", (Object)"Dublin", "CamelFileName", (Object)"dublin.txt");
        mock.assertIsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        FileConsumerFailureHandledTest.assertFiles("dublin.txt", false);
    }

    public void testMadrid() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:error");
        mock.expectedBodiesReceived(new Object[]{"Madrid"});
        this.template.sendBodyAndHeader("file:target/messages/input/", (Object)"Madrid", "CamelFileName", (Object)"madrid.txt");
        mock.assertIsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        FileConsumerFailureHandledTest.assertFiles("madrid.txt", true);
    }

    private static void assertFiles(String filename, boolean deleted) throws InterruptedException {
        File file = new File("target/messages/input/" + filename);
        FileConsumerFailureHandledTest.assertEquals((String)("File " + filename + " should be deleted: " + deleted), (boolean)deleted, (!file.exists() ? 1 : 0) != 0);
        String lock = filename + ".camelLock";
        file = new File("target/messages/input/" + lock);
        FileConsumerFailureHandledTest.assertFalse((String)("File " + lock + " should be deleted"), (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").maximumRedeliveries(2).redeliveryDelay(0L).logStackTrace(false));
                this.onException(ValidationException.class).onWhen(this.exceptionMessage().contains((Object)"beer")).handled(false).to("mock:beer");
                this.onException(ValidationException.class).handled(true).to("mock:invalid");
                ((RouteDefinition)this.from("file:target/messages/input/?delete=true").process((Processor)new MyValidatorProcessor())).to("mock:valid");
            }
        };
    }

    private static class MyValidatorProcessor
    implements Processor {
        private MyValidatorProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            if ("London".equals(body)) {
                throw new ValidationException(exchange, "Forced exception by unit test");
            }
            if ("Madrid".equals(body)) {
                throw new RuntimeCamelException("Madrid is not a supported city");
            }
            if ("Dublin".equals(body)) {
                throw new ValidationException(exchange, "Dublin have good beer");
            }
            exchange.getOut().setBody((Object)("Hello " + body));
        }
    }
}

