/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class FileBeginFailureOneTimeTest
extends ContextTestSupport {
    private MyStrategy myStrategy = new MyStrategy();

    @Override
    protected void setUp() throws Exception {
        FileBeginFailureOneTimeTest.deleteDirectory("target/begin");
        super.setUp();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myStrategy", (Object)this.myStrategy);
        return jndi;
    }

    public void testBeginFailureOneTime() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("file://target/begin", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        FileBeginFailureOneTimeTest.assertEquals((String)"Begin should have been invoked 2 times", (int)2, (int)this.myStrategy.getInvoked());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/begin?processStrategy=#myStrategy").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    private static class MyStrategy
    implements GenericFileProcessStrategy<File> {
        private volatile int invoked;

        private MyStrategy() {
        }

        public void prepareOnStartup(GenericFileOperations<File> fileGenericFileOperations, GenericFileEndpoint<File> fileGenericFileEndpoint) throws Exception {
        }

        public boolean begin(GenericFileOperations<File> fileGenericFileOperations, GenericFileEndpoint<File> fileGenericFileEndpoint, Exchange exchange, GenericFile<File> fileGenericFile) throws Exception {
            ++this.invoked;
            if (this.invoked <= 1) {
                throw new IllegalArgumentException("Damn I cannot do this");
            }
            return true;
        }

        public void abort(GenericFileOperations<File> fileGenericFileOperations, GenericFileEndpoint<File> fileGenericFileEndpoint, Exchange exchange, GenericFile<File> fileGenericFile) throws Exception {
        }

        public void commit(GenericFileOperations<File> fileGenericFileOperations, GenericFileEndpoint<File> fileGenericFileEndpoint, Exchange exchange, GenericFile<File> fileGenericFile) throws Exception {
        }

        public void rollback(GenericFileOperations<File> fileGenericFileOperations, GenericFileEndpoint<File> fileGenericFileEndpoint, Exchange exchange, GenericFile<File> fileGenericFile) throws Exception {
        }

        public int getInvoked() {
            return this.invoked;
        }
    }
}

