/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.direct.DirectConsumerNotAvailableException;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class DirectNoConsumerTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testInOnly() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("direct:foo");
            }
        });
        this.context.start();
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            DirectNoConsumerTest.fail((String)"Should throw an exception");
        }
        catch (CamelExecutionException e) {
            DirectNoConsumerTest.assertIsInstanceOf(DirectConsumerNotAvailableException.class, e.getCause());
        }
    }

    public void testInOut() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("direct:foo");
            }
        });
        this.context.start();
        try {
            this.template.requestBody("direct:start", (Object)"Hello World");
            DirectNoConsumerTest.fail((String)"Should throw an exception");
        }
        catch (CamelExecutionException e) {
            DirectNoConsumerTest.assertIsInstanceOf(DirectConsumerNotAvailableException.class, e.getCause());
        }
    }

    @Test
    public void testFailIfNoConsumerFalse() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("direct:foo?failIfNoConsumers=false");
            }
        });
        this.context.start();
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
        }
        catch (CamelExecutionException e) {
            DirectNoConsumerTest.fail((String)"Should not throw an exception");
        }
    }

    @Test
    public void testFailIfNoConsumersAfterConsumersLeave() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo").routeId("stopThisRoute").to("mock:foo");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.stopRoute("stopThisRoute");
        TimeUnit.MILLISECONDS.sleep(100L);
        try {
            this.template.sendBody("direct:foo", (Object)"Hello World");
            DirectNoConsumerTest.fail((String)"Should throw an exception");
        }
        catch (CamelExecutionException e) {
            DirectNoConsumerTest.assertIsInstanceOf(DirectConsumerNotAvailableException.class, e.getCause());
        }
    }

    @Test
    public void testFailIfNoConsumersWithValidConsumer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:in").to("direct:foo");
                this.from("direct:foo").to("mock:foo");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:in", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFailIfNoConsumersFalseWithPipeline() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:in").to("direct:foo?failIfNoConsumers=false")).to("direct:bar");
                this.from("direct:bar").to("mock:foo");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:in", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConfigOnAConsumer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo?failIfNoConsumers=false").to("log:test");
            }
        });
        this.context.start();
    }
}

