/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.bean.MyFooBean;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class BeanRefMethodNotFoundTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        return jndi;
    }

    public void testBeanRefMethodNotFound() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:a").routeId("a").bean((Object)"foo", "hello")).to("mock:a");
                ((RouteDefinition)this.from("direct:b").routeId("b").bean((Object)"foo", "bye")).to("mock:b");
            }
        });
        try {
            this.context.start();
            BeanRefMethodNotFoundTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            BeanRefMethodNotFoundTest.assertEquals((String)"b", (String)e.getRouteId());
            MethodNotFoundException cause = BeanRefMethodNotFoundTest.assertIsInstanceOf(MethodNotFoundException.class, e.getCause().getCause());
            BeanRefMethodNotFoundTest.assertEquals((String)"bye", (String)cause.getMethodName());
        }
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

