/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class BeanOverloadedCovariantMethodTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testHelloCovariantOverload() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MySuperBean.class, "hello")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Claus from super class"});
        this.template.sendBody("direct:start", (Object)"Claus");
        this.assertMockEndpointsSatisfied();
    }

    public void testHelloCovariantOverloadNoNameOrParameters() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MySuperBean.class)).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello null from super class"});
        this.template.sendBody("direct:start", null);
        this.assertMockEndpointsSatisfied();
    }

    public void testHelloCovariantOverloadNoParameters() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MySuperBean.class, "hello")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello null from super class"});
        this.template.sendBody("direct:start", null);
        this.assertMockEndpointsSatisfied();
    }

    public void testHelloCovariantOverloadFromParameters() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MySuperBean.class, "hello(String)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello null from super class"});
        this.template.sendBody("direct:start", null);
        this.assertMockEndpointsSatisfied();
    }

    public static class MySuperBean
    extends MyBean {
        @Override
        public String hello(String name) {
            return "Hello " + name + " from super class";
        }
    }

    public static class MyBean {
        public Object hello(String name) {
            return "Hello " + name + " from base class";
        }
    }
}

