/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.component.bean.AmbiguousMethodCallException;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.impl.DefaultExchange;

public class BeanInfoInheritanceTest
extends ContextTestSupport {
    public void testInheritance() throws Exception {
        BeanInfo beanInfo = new BeanInfo((CamelContext)this.context, Y.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)new Request());
        try {
            MethodInvocation mi = beanInfo.createInvocation(null, (Exchange)exchange);
            BeanInfoInheritanceTest.assertNotNull((Object)mi);
            BeanInfoInheritanceTest.assertEquals((String)"process", (String)mi.getMethod().getName());
            BeanInfoInheritanceTest.assertEquals((String)"Y", (String)mi.getMethod().getDeclaringClass().getSimpleName());
        }
        catch (AmbiguousMethodCallException e) {
            BeanInfoInheritanceTest.fail((String)"This should not be ambiguous!");
        }
    }

    public void testNoInheritance() throws Exception {
        BeanInfo beanInfo = new BeanInfo((CamelContext)this.context, A.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)new Request());
        try {
            MethodInvocation mi = beanInfo.createInvocation(null, (Exchange)exchange);
            BeanInfoInheritanceTest.assertNotNull((Object)mi);
            BeanInfoInheritanceTest.assertEquals((String)"process", (String)mi.getMethod().getName());
            BeanInfoInheritanceTest.assertEquals((String)"A", (String)mi.getMethod().getDeclaringClass().getSimpleName());
        }
        catch (AmbiguousMethodCallException e) {
            BeanInfoInheritanceTest.fail((String)"This should not be ambiguous!");
        }
    }

    public void testInheritanceAndOverload() throws Exception {
        BeanInfo beanInfo = new BeanInfo((CamelContext)this.context, Z.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)new Request());
        try {
            beanInfo.createInvocation(null, (Exchange)exchange);
            BeanInfoInheritanceTest.fail((String)"This should be ambiguous!");
        }
        catch (AmbiguousMethodCallException ambiguousMethodCallException) {
            // empty catch block
        }
    }

    public static class A {
        public void doSomething(String body) {
        }

        public int process(Request request) {
            return 0;
        }
    }

    public static class Z
    extends Y {
        public int compute(Request request) {
            return 2;
        }

        public int process(Request request, String body) {
            return 3;
        }
    }

    public static class Y
    extends X {
        @Override
        public int process(Request request) {
            return 1;
        }

        public int compute(String body) {
            return 2;
        }
    }

    public static class X {
        public int process(Request request) {
            return 0;
        }
    }

    public static class Request {
        int x;
    }
}

