/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.io.ByteArrayInputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.AmbiguousMethodCallException;
import org.apache.camel.component.bean.MyDummyBean;
import org.apache.camel.impl.JndiRegistry;

public class BeanExplicitMethodAmbiguousTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("dummy", (Object)new MyDummyBean());
        return jndi;
    }

    public void testBeanExplicitMethodAmbiguous() throws Exception {
        try {
            this.template.requestBody("direct:hello", (Object)"Camel");
            BeanExplicitMethodAmbiguousTest.fail((String)"Should thrown an exception");
        }
        catch (Exception e) {
            AmbiguousMethodCallException cause = BeanExplicitMethodAmbiguousTest.assertIsInstanceOf(AmbiguousMethodCallException.class, e.getCause());
            BeanExplicitMethodAmbiguousTest.assertEquals((int)2, (int)cause.getMethods().size());
        }
    }

    public void testBeanExplicitMethodHandler() throws Exception {
        String out = (String)this.template.requestBody("direct:bye", (Object)"Camel", String.class);
        BeanExplicitMethodAmbiguousTest.assertEquals((String)"Bye Camel", (String)out);
    }

    public void testBeanExplicitMethodInvocationStringBody() throws Exception {
        String out = (String)this.template.requestBody("direct:foo", (Object)"Camel", String.class);
        BeanExplicitMethodAmbiguousTest.assertEquals((String)"String", (String)out);
    }

    public void testBeanExplicitMethodInvocationInputStreamBody() throws Exception {
        String out = (String)this.template.requestBody("direct:foo", (Object)new ByteArrayInputStream("Camel".getBytes()), String.class);
        BeanExplicitMethodAmbiguousTest.assertEquals((String)"InputStream", (String)out);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:hello").bean((Object)"dummy", "hello", true);
                this.from("direct:bye").bean((Object)"dummy", true);
                this.from("direct:foo").bean((Object)"dummy", "bar", true);
            }
        };
    }
}

