/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.io.File;
import java.net.URL;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.builder.xml.XsltBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class XsltOutputFileTest
extends ContextTestSupport {
    public void testXsltOutputFile() throws Exception {
        XsltOutputFileTest.createDirectory("target/xslt");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        mock.expectedFileExists("target/xslt/xsltme.xml");
        ((ValueBuilder)mock.message(0).body()).isInstanceOf(File.class);
        this.template.sendBodyAndHeader("direct:start", (Object)"<hello>world!</hello>", "CamelXsltFileName", (Object)"target/xslt/xsltme.xml");
        mock.assertIsSatisfied();
    }

    public void testXsltOutputFileMissingHeader() throws Exception {
        try {
            this.template.sendBody("direct:start", (Object)"<hello>world!</hello>");
            XsltOutputFileTest.fail((String)"Should thrown exception");
        }
        catch (CamelExecutionException e) {
            NoSuchHeaderException nshe = XsltOutputFileTest.assertIsInstanceOf(NoSuchHeaderException.class, e.getCause());
            XsltOutputFileTest.assertEquals((String)"CamelXsltFileName", (String)nshe.getHeaderName());
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                URL styleSheet = ((Object)((Object)this)).getClass().getResource("example.xsl");
                ((RouteDefinition)this.from("direct:start").process((Processor)XsltBuilder.xslt((URL)styleSheet).outputFile())).to("mock:result");
            }
        };
    }
}

