/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;

public class NotifyBuilderWhenDoneByIndexTest
extends ContextTestSupport {
    public void testDoneByIndex() throws Exception {
        final AtomicInteger counter = new AtomicInteger();
        this.getMockEndpoint("mock:split").whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                counter.incrementAndGet();
            }
        });
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDoneByIndex(0).create();
        NotifyBuilderWhenDoneByIndexTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("seda:foo", (Object)"A,B,C");
        NotifyBuilderWhenDoneByIndexTest.assertEquals((boolean)true, (boolean)notify.matchesMockWaitTime());
        NotifyBuilderWhenDoneByIndexTest.assertEquals((int)3, (int)counter.get());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)this.from("seda:foo").routeId("foo").delay(500L).split((Expression)this.body().tokenize(",")).to("mock:split")).end().to("mock:foo");
            }
        };
    }
}

