/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.JndiRegistry;

public class NotifyBuilderFromRouteTest
extends ContextTestSupport {
    public void testDoneFromRoute() throws Exception {
        NotifyBuilder builder = new NotifyBuilder((CamelContext)this.context).fromRoute("foo").whenDone(1);
        builder.create();
        this.template.sendBody("seda:foo", (Object)"Hello world!");
        NotifyBuilderFromRouteTest.assertTrue((boolean)builder.matchesMockWaitTime());
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry registry = super.createRegistry();
        registry.bind("proxy", (Object)new ProxyComponent());
        return registry;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("proxy:seda:foo").routeId("foo").to("mock:foo");
            }
        };
    }

    private static final class ProxyEndpoint
    extends DefaultEndpoint {
        private final Endpoint target;

        private ProxyEndpoint(ProxyComponent component, String uri, String target) {
            super(uri, (Component)component);
            this.target = this.getCamelContext().getEndpoint(target);
        }

        public Producer createProducer() throws Exception {
            return this.target.createProducer();
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return this.target.createConsumer(processor);
        }

        public boolean isSingleton() {
            return this.target.isSingleton();
        }
    }

    private static final class ProxyComponent
    extends DefaultComponent {
        private ProxyComponent() {
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
            return new ProxyEndpoint(this, uri, remaining);
        }
    }
}

