/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;

public class UnitOfWorkSyncProcessTest
extends ContextTestSupport {
    private static String consumerThread;
    private static String afterThread;
    private static String taskThread;
    private static String doneThread;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Override
    protected void tearDown() throws Exception {
        this.executorService.shutdownNow();
        super.tearDown();
    }

    public void testUnitOfWorkSync() throws Exception {
        if (UnitOfWorkSyncProcessTest.isPlatform("aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.assertMockEndpointsSatisfied();
        UnitOfWorkSyncProcessTest.assertEquals((String)taskThread, (String)afterThread);
        UnitOfWorkSyncProcessTest.assertNotSame((Object)doneThread, (Object)afterThread);
        UnitOfWorkSyncProcessTest.assertNotSame((Object)doneThread, (Object)consumerThread);
        UnitOfWorkSyncProcessTest.assertEquals((String)consumerThread, (String)doneThread);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from((Endpoint)new MyEndpoint()).process((Processor)new AsyncProcessor(){

                    public boolean process(final Exchange exchange, final AsyncCallback callback) {
                        UnitOfWorkSyncProcessTest.this.executorService.submit(new Runnable(){

                            @Override
                            public void run() {
                                taskThread = Thread.currentThread().getName();
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                exchange.getIn().setHeader("foo", (Object)123);
                                callback.done(false);
                            }
                        });
                        return false;
                    }

                    public void process(Exchange exchange) throws Exception {
                    }
                })).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        afterThread = Thread.currentThread().getName();
                    }
                })).to("mock:result");
            }
        };
    }

    private final class MyConsumer
    implements Consumer {
        private Processor processor;
        private Endpoint endpoint;

        private MyConsumer(Endpoint endpoint, Processor processor) {
            this.endpoint = endpoint;
            this.processor = processor;
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        public void start() throws Exception {
            consumerThread = Thread.currentThread().getName();
            DefaultExchange exchange = new DefaultExchange((CamelContext)UnitOfWorkSyncProcessTest.this.context);
            exchange.setProperty("CamelUnitOfWorkProcessSync", (Object)true);
            exchange.addOnCompletion((Synchronization)new SynchronizationAdapter(){

                public void onDone(Exchange exchange) {
                    doneThread = Thread.currentThread().getName();
                }
            });
            this.processor.process((Exchange)exchange);
        }

        public void stop() throws Exception {
        }
    }

    private final class MyEndpoint
    extends DefaultEndpoint {
        private MyEndpoint() {
        }

        public Producer createProducer() throws Exception {
            return null;
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return new MyConsumer((Endpoint)this, processor);
        }

        protected String createEndpointUri() {
            return "myEndpoint://foo";
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

